#ifndef BOOKLISTITEM_H
#define BOOKLISTITEM_H

#include <QWidget>
#include <QApplication>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QPainter>
#include <QAbstractKineticScroller>
#include "book.h"

//TODO: Some refactoring needed. Wordwrap on QLabels and QScrollArea don't mix well..

class BookListItem : public QWidget{
    Q_OBJECT
public:
    BookListItem(Book *book, QWidget *parent = 0, QAbstractKineticScroller *scrollable = 0) : QWidget(parent){
        thisBook = book;

        QHBoxLayout *mainLayout = new QHBoxLayout(this);
        QMargins margins(10, 10, 10, 10);
        mainLayout->setContentsMargins(margins);
        QPixmap temp = book->getCoverImage();
        if(!temp.isNull()){
            QLabel *image = new QLabel(this);
            temp = temp.scaledToWidth(100);
            image->setPixmap(temp);
            image->setFixedWidth(temp.width());
            mainLayout->addWidget(image);
            mainLayout->setAlignment(image, Qt::AlignLeft | Qt::AlignTop);
        }



        QVBoxLayout *subLayout = new QVBoxLayout();
        mainLayout->addLayout(subLayout);

        QLabel *title = new QLabel(book->getTitle());
        title->setWordWrap(true);
        title->setMinimumWidth(250);
        title->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);
        subLayout->addWidget(title);
        subLayout->setAlignment(title, Qt::AlignLeft);

        QLabel *author = new QLabel(book->getAuthor());
        author->setWordWrap(true);
        author->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);
        subLayout->addWidget(author);

        QLabel *category = new QLabel(book->getCategory());
        category->setWordWrap(true);
        category->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding);
        subLayout->addWidget(category);
        subLayout->setAlignment(category, Qt::AlignLeft);


        setLayout(mainLayout);
        adjustSize(); 
        setAutoFillBackground(true);

        scroller = scrollable;
        
    }
    ~BookListItem(){

    }
protected:
    void mouseReleaseEvent(QMouseEvent *event){
        if(scroller){
            if(scroller->state() == QAbstractKineticScroller::Inactive)
                emit selected(thisBook);
        }
        QPalette palette = QApplication::palette();
        palette.setColor(QPalette::Window, palette.color(QPalette::Button));
        setPalette(palette);
    }
    void mousePressEvent(QMouseEvent *event){
        QPalette palette;
        palette.setCurrentColorGroup(QPalette::Active);
        QBrush brush = palette.highlight();
        palette.setColor(QPalette::Window, brush.color());
        setPalette(palette);
    }

private:
    Book *thisBook;
    QAbstractKineticScroller *scroller;

signals:
    void selected(Book*);

};

#endif
