#ifndef LIBRARY_H
#define LIBRARY_H

class QObject;
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QStringList>
#include <QDir>
#include "book.h"

class Library : public QObject{
    Q_OBJECT
public:
    Library(const QString &libraryDirectory, const QString &databasename, QObject *parent = 0);
    ~Library();

    void scanDirectory(const QString&);

//    void loadBooksfromdb();
//    void saveBooktodb(Book*);
    QList<Book*> getBooks();

private:
    QStringList filenames;
    void connectdb(const QString&);
    void saveBookProgress(Book*);
    void loadBookProgress(Book*);
//    bool checkForChanges();

    QSqlDatabase database;

    QList<Book*> books;
};

#endif
