#include "library.h"

#include <QSqlError>

Library::Library(const QString &libraryDirectory, const QString &databasename, QObject *parent) : QObject(parent)
{
    connectdb(databasename);
    scanDirectory(libraryDirectory);
    //loadBooksfromdb();
    //checkForChanges();
}

Library::~Library()
{
    for(QList<Book*>::iterator iter = books.begin(); iter != books.end(); ++iter)
    {
        saveBookProgress(*iter);
    }
}

void Library::scanDirectory(const QString &directory)
{
    QDir dir(directory);

    if(dir.exists()){
        QStringList sbooks = dir.entryList(QStringList("*.epub"), QDir::Files);
        for(QStringList::iterator iter = sbooks.begin(); iter != sbooks.end(); ++iter)
        {
            (*iter) = dir.absolutePath() + "/" + (*iter);
        }
        filenames.append(sbooks);
        QStringList dirs = dir.entryList(QDir::Dirs | QDir::NoSymLinks);

        QStringList::const_iterator iter;
        for(iter = dirs.begin(); iter != dirs.end(); ++iter){
            if((*iter) != "." && (*iter) != "..")
                scanDirectory(dir.absolutePath() + "/" + *iter);
        }
    }

    for(QStringList::const_iterator iter = filenames.begin(); iter != filenames.end(); ++iter)
    { 
        Book *book = new Book(*iter, true);         
//        saveBooktodb(book);
        books.push_back(book);
        loadBookProgress(book);
    }
}

void Library::connectdb(const QString &databasefile)
{
    database = QSqlDatabase::addDatabase("QSQLITE");
    database.setDatabaseName(databasefile);

    if(!database.open()){
        qDebug() << "Cannot connect to database!";
        return;
    }

    /*if(!database.tables().contains("books")){
        QSqlQuery query("CREATE TABLE books(INTEGER PRIMARY KEY, title, author, category, publishdate, filename, cover, lastspot)", database);
        if(!query.exec())
            qDebug() << "Failed to create table!";
    }*/
    if(!database.tables().contains("recent")){
        QSqlQuery query("CREATE TABLE recent(INTEGER PRIMARY KEY, title, filename)", database);
        if(!query.exec())
            qDebug() << "Failed to create table!";
    }
    if(!database.tables().contains("lastspot")){
        QSqlQuery query("CREATE TABLE lastspot(title, filename, link, element, text, scroll)", database);
        if(!query.exec())
            qDebug() << "Failed to create table!";
    }

}

void Library::saveBookProgress(Book *book)
{
    
    BookProgress progress = book->getProgress();
    if(!progress.isValid())
        return;
    QSqlQuery selectQuery("SELECT * FROM lastspot WHERE filename=:filename", database);
    selectQuery.bindValue(":filename", book->getFilename());
    selectQuery.exec();
    if(!selectQuery.next()){
        QSqlQuery insertQuery("INSERT INTO lastspot VALUES(:title, :filename, :link, :element, :text, :scroll)");
        insertQuery.bindValue(":title", book->getTitle());
        insertQuery.bindValue(":filename", book->getFilename());
        insertQuery.bindValue(":link", progress.getLink());
        insertQuery.bindValue(":element", progress.getElement());
        insertQuery.bindValue(":text", progress.getText());
        insertQuery.bindValue(":scroll", progress.getScroll());

        if(!insertQuery.exec())
            qDebug() << "Database error: " << insertQuery.lastError();
        else
            qDebug() << "Wrote " << insertQuery.size() << " lines to database.";
    }else{
        QSqlQuery updateQuery("UPDATE lastspot SET link=:link, element=:element, text=:text, scroll=:scroll WHERE filename=:filename", database);
        updateQuery.bindValue(":link", progress.getLink());
        updateQuery.bindValue(":element", progress.getElement());
        updateQuery.bindValue(":text", progress.getText());
        updateQuery.bindValue(":scroll", progress.getScroll());
        updateQuery.bindValue(":filename", book->getFilename());

        if(!updateQuery.exec())
            qDebug() << "Database error: " << updateQuery.lastError();
    }
}

void Library::loadBookProgress(Book *book)
{
    QSqlQuery query("SELECT * FROM lastspot WHERE filename=:filename", database);
    query.bindValue(":filename", book->getFilename());
    if(query.exec()){
        if(query.next()){

            BookProgress progress;
            progress.setProgress(query.value(2).toString(), query.value(3).toString(), query.value(4).toString(), query.value(5).toInt());

            book->setProgress(progress);
        }
    }
    else{
        qDebug() << "Database error: " << query.lastError();
    }
}

/*bool Library::checkForChanges()
{
    QStringList filesindb;
    for(QList<Book*>::iterator iter = books.begin(); iter != books.begin(); ++iter)
    {
        Book *book = *iter;
        if(!filenames.contains(book->getFilename())){
            books.removeOne(book);

        }else{
            filesindb.push_back(book->getFilename());
        }
    }

    QStringList newfiles;
    for(QStringList::const_iterator iter = filenames.begin(); iter != filenames.end(); ++iter)
    {
        if(!filesindb.contains(*iter))
            newfiles.push_back(*iter);
    }

    for(QStringList::const_iterator iter = newfiles.begin(); iter != newfiles.end(); ++iter)
    { 
        Book *book = new Book(*iter);         
//        saveBooktodb(book);
        books.push_back(book);
    }

}

void Library::loadBooksfromdb()
{

    QSqlQuery query("SELECT * FROM books");

    if(!query.exec())
        return;

    while(query.next()){
        QString title = query.value(0).toString();
        QString author = query.value(1).toString();
        QString category = query.value(2).toString();
        QString published = query.value(3).toString();
        QString filename = query.value(4).toString();

        Book *book = new Book(filename, true);         
        book->setTitle(title);
        book->setAuthor(author);
        book->setCategory(category);
        book->setPublishDate(published);

        books.push_back(book);
    }
}

void Library::saveBooktodb(Book *book)
{
}*/

QList<Book*> Library::getBooks()
{
    return books;
}
