#ifndef BOOK_H
#define BOOK_H

#include <QTextDocument>
#include <QTextBlock>
#include <QHash>
#include <QList>
#include <QDate>
#include <QObject>

#include "epubgenerator.h"
#include "bookmark.h"
#include "annotation.h"

class BookProgress
{
public:
    BookProgress() : scrollProgress(0){}
    //TODO: Check for correct values.
    void setProgress(QString link, QString element, QString text, int scroll){
        progressLink = link;
        progressElement = element;
        progressText = text;
        scrollProgress = scroll;
    }

    QString getLink(){return progressLink;}
    QString getElement(){return progressElement;}
    QString getText(){return progressText;}
    int getScroll(){return scrollProgress;}
    bool isValid(){ 
        return (!progressLink.isEmpty() + !progressElement.isEmpty() + !progressText.isEmpty()+scrollProgress)!=0?true:false;
    }
private:
    //Variables for saving book progress
    QString progressLink;
    QString progressElement;
    QString progressText;
    int scrollProgress;
};

class Book : public QObject
{
    Q_OBJECT
public:
    Book(const QString &bookFilename, bool loadLater = false);
    ~Book();

    void openBook(const QString &bookFilename);
    void load();
    bool isLoaded();

    QString getFirstChapter();
    QString getNextChapter(QString&);
    QString getChapter(QString);

    QString getCover();
    QString getNextSection(int &number);
    QString getPreviousSection(int &number);
    QString getSection(int);
    int getSectionNumber(QString);
    QString getBook();
    QList<QString> getTOC();
    QString getFilename();

    QString getTitle();
    QString getAuthor();
    QString getCategory();
    QPixmap getCoverImage();

    BookProgress getProgress();
    void setProgress(BookProgress);

    bool hasTOC();

    QNetworkAccessManager *getResourceManager();

private:
    QString title;
    QString author;
    QString publisher;
    QString description;
    QString subject;
    QDate publishDate;
    QString category;
    QString copyright;
    QString filename;
    
    QList<QString> toc;

    QHash<QString, QString*> document;
    QList<QString*> sections;

    QPixmap coverImage;

    QList<Bookmark> bookmarks;
    QList<Annotation> annotations;

    EpubGenerator *generator;

    BookProgress bookProgress;

    bool loaded;


public slots:
    void setTitle(QString);
    void setAuthor(QString);
    void setPublisher(QString);
    void setDescription(QString);
    void setSubject(QString);
    void setPublishDate(QString);
    void setCategory(QString);
    void setCopyright(QString);

    void addChapter(QString, QString*);
    void addTOCItem(QString);
    void addSection(QString*);

    void addCoverImage(QPixmap);

};

#endif
