#!/usr/bin/python2.5
# -*- coding: latin-1 -*-

#TODO
#Startup via GUI: Redraw needed? (screen blank remains blank in scratchbox)
#Cleanup code and follow best practice, tab4, (google)

import os
import sys
import time
import datetime
import math
import random

import pygame
from pygame.locals import *

from gnome import gconf 
import gobject
import gtk
import hildon

from sun import *

#os.environ["SDL_VIDEO_X11_WMCLASS"]="mClock"

sys.path.append('/opt/tomch.com/mClock/lib/')
path = '/opt/tomch.com/mClock/share/'
pathSysIcons = '/usr/share/icons/hicolor/48x48/hildon'

program = hildon.Program.get_instance()
window = hildon.Window()
program.add_window(window)
area = gtk.DrawingArea()

bFullscreen = True
bTimerRunning = False
screen = pygame.Surface((800, 400))
currentMap = pygame.Surface((800, 400))
nightMap = pygame.Surface((800, 400))
dayMap = pygame.Surface((800, 400))

maps = ["1-Winter-January.jpg", "2-Spring-April.jpg", "3-Summer-July.jpg", "4-Fall-October.jpg"]
currentMapIndex = 2
time.localtime()[7] #Day of year, 1-366
#From http://www.astro.uu.nl/~strous/AA/en/antwoorden/seizoenen.html
#timedelta(  	[days[, seconds[, microseconds[, milliseconds[, minutes[, hours[, weeks]]]]]]])
timeDeltaSpring = datetime.timedelta(365,  2, 0, 0, 49, 5, 0)
timeDeltaSummer = datetime.timedelta(365, 57, 0, 0, 47, 5, 0)
timeDeltaAutumn = datetime.timedelta(365, 31, 0, 0, 48, 5, 0)
timeDeltaWinter = datetime.timedelta(365, 33, 0, 0, 49, 5, 0)

startSpring2005 = datetime.datetime(2005,  3, 20, 11, 33, 19)  #20 March 2005	11:33:19
startSummer2005 = datetime.datetime(2005,  6, 21,  6, 39, 11)  # 21 June 2005 06:39:11
startAutumn2005 = datetime.datetime(2005,  9, 22, 22, 16, 34)  #22 September 2005 22:16:34
startWinter2005 = datetime.datetime(2005, 12, 21, 18, 34, 51)  #21 December 2005 18:34:51

yearsSince = time.localtime()[0] - 2005

startSpring = startSpring2005+yearsSince*timeDeltaSpring
startSummer = startSummer2005+yearsSince*timeDeltaSummer
startAutum = startAutumn2005+yearsSince*timeDeltaAutumn
startWinter = startWinter2005+yearsSince*timeDeltaWinter

now = datetime.datetime.utcnow()
if(now<startSpring or now>startWinter):
  currentMapIndex=0
elif(now>startSpring and now<startSummer):
  currentMapIndex=1
elif(now>startSummer and now<startAutum):
  currentMapIndex=2
elif(now>startAutum and now<startWinter):
  currentMapIndex=3
#print "Season = "+maps[currentMapIndex].split("-")[1]

#################################################
# Class that handles all display stuff
#################################################
class display:

 def menu_button_clicked(button, label):
  dlg = gtk.AboutDialog()
  dlg.set_name('mClock')
  dlg.set_program_name('mClock')
  dlg.set_version("0.7.2")
  dlg.set_copyright("© Thomas Wälti")
  dlg.set_website("www.tomch.com")
  dlg.set_website_label("http://www.tomch.com")
  dlg.set_comments("Touch the map to switch display mode (min/max)")
  dlg.connect( 'response', lambda dlg, response: dlg.destroy())
  for parent in dlg.vbox.get_children():
      for child in parent.get_children():
          if isinstance(child, gtk.Label):
              child.set_selectable(False) 
  dlg.run()

 def __init__(self):

  #Setup the Pygame>SDL>GTK stuff
  WINX = 800
  WINY = 432
  gtk.set_application_name("mClock")

  #Create the window
  global window
  window.connect('delete-event', gtk.main_quit)
  window.set_resizable(False)

  theDate = datetime.datetime.now().strftime("%a %d %b")  
  window.set_title("mClock - "+theDate)

  #Add an about menu dialog
  global menu
  menu = hildon.AppMenu()
  button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
  button.set_label("About")
  button.connect("clicked", self.menu_button_clicked)
  menu.append(button)
  menu.show_all()
  window.set_app_menu(menu)

  #Create the area for the map
  global area
  area.set_app_paintable(True)
  area.set_size_request(WINX, WINY)
  window.add(area)
  area.realize()

  # Force SDL to write on our drawing area
  os.putenv('SDL_WINDOWID', str(area.window.xid))
  # We need to flush the XLib event loop otherwise we can't
  # access the XWindow which set_mode() requires
  gtk.gdk.flush()

  pygame.init()
  pygame.mixer.quit()
  pygame.mouse.set_visible(False)
  pygame.display.set_mode((WINX, WINY), 0, 16)
  screen = pygame.display.get_surface()

  blue = Color( "#202080" )
  black = Color( "black" )
  global sunIcon
  sunIcon = pygame.image.load(os.path.join(path,"sun.png")).convert_alpha() 
  global nightMap
  nightMap.fill(black)
  nightMap.blit(pygame.image.load(os.path.join(path,"0-Night.jpg")).convert(),(0,0))
  global dayMap
  dayMap = pygame.image.load(os.path.join(path,maps[currentMapIndex])).convert()
  pygame.draw.line(dayMap, blue, (0,200), (800,200), 1) #equator

  screen.blit(nightMap, (0, 0))
  pygame.display.flip()

  gobject.idle_add(pygame.display.update)
  window.show_all()

#################################################
 def drawDayMap(self):
  theSun = Sun()
  global dayMap
  global currentMap
  currentMap = dayMap.copy()
  font = pygame.font.Font(None, 9)
  blue = Color( "#202080" )
  yellow = Color( "yellow" )	#See pygame.colordict
  colorMask = Color( "pink" )
  now = datetime.datetime.utcnow()
  year = now.year
  month = now.month
  day = now.day
  hours = now.hour
  minutes = now.minute
  seconds = now.second
  timeInMinutes = (now.hour)*60.0+(1.0/60.0*now.minute)

  height = currentMap.get_height()
  width = currentMap.get_width()
  step = 10;

  N = theSun.daysSince2000Jan0(year, month, day)
  res =  theSun.sunRADec(N)
  declination = res[1]
  dec=declination
  if(dec==0.0):
      dec=-0.001
  midday = datetime.datetime(year, month, day, 12, 00, 00)
  GMST0 = theSun.GMST0(theSun.daysSince2000Jan0(year,month,day))
  valueTau = -10.0
  tau=0.0 # Hour Angle of the Sun
  tau=GMST0

  STD = 1.0*(hours) + minutes/60.0 + seconds/3600.0
  GHA = theSun.computeGHA(day, month, year, STD);

  lon=0    #For UT/GMT
  d = theSun.daysSince2000Jan0(year,month,day)
  # Compute local sidereal time of this moment
  sidtime = theSun.GMST0(d)
  # Compute Sun's RA + Decl at this moment
  res = theSun.sunRADec(d)

  sRA = res[0]
  sdec = res[1]
  sr = res[2]
  # Compute time when Sun is at south - in hours UT
  tsouth = 12.0 - theSun.rev180(sidtime - sRA)/15.0;
  tau=GHA
  K = math.pi/180.0
  y0=90
  x0=180    #the center of the map is at x0, y0

  #setup some debugtext
  debugText = maps[currentMapIndex].split("-")[1]
  bPosDec = True
  if(dec < 0):
      bPosDec = False

  for i in range(-180,180,1):
    longitude=i+tau;
    tanLat = - math.cos(longitude*K)/math.tan(dec*K)
    arctanLat = math.atan(tanLat)/K
    y1 = y0 - int(arctanLat+0.5)    #int
    longitude=longitude+1
    tanLat = - math.cos(longitude*K)/math.tan(dec*K)
    arctanLat = math.atan(tanLat)/K
    y2 = y0 - int(arctanLat+0.5)
    pygame.draw.line(currentMap, blue, (2.22*(x0+i),2.22*y1), (2.22*(x0+i+1),2.22*y2), 3)
    if(bPosDec):
      pygame.draw.line(currentMap, colorMask, (2.22*(x0+i),2.22*y1), (2.22*(x0+i),400), 3)
    else:
      pygame.draw.line(currentMap, colorMask, (2.22*(x0+i),2.22*y1), (2.22*(x0+i),0), 3)
  
  #Draw the sun
  x = 400
  if(tau<180.0):
    x = 400.0-int(800.0/360.0*tau)
  else:
    x = 1200-int(800.0/360.0*tau)
  #Blit the sun icon at the current sun position over the earth; however, subtract 6px on both coordinates as the icon itself is 12x12px
  currentMap.blit(sunIcon, (int(x)-6,200-int(400/180*dec)-6))
  currentMap.set_colorkey(colorMask, pygame.RLEACCEL)

  return currentMap
   
#################################################  
 def UpdateTime(self, displayMode, forceRedraw):

  global screen
  global window

  #Update date
  if datetime.datetime.now().hour == 0 and datetime.datetime.now().minute == 0:
    theDate = datetime.datetime.now().strftime("%a %d %b")  
    window.set_title("mClock - "+theDate)

  if forceRedraw==True or displayMode=="maxi" or datetime.datetime.now().minute %2 == 0:
    screen = pygame.display.get_surface()
    screen.blit(nightMap,(0,0))
    screen.blit(self.drawDayMap(),(0,0))  
    if displayMode=="maxi":
      theTime = datetime.datetime.now().strftime("%H:%M")
      timeFont = pygame.font.Font(None, 384)
      textTime = timeFont.render(theTime, 1, (192, 192, 255, 192))
      screen.blit(textTime, ((screen.get_width()-textTime.get_width())/2,(400-textTime.get_height())/2))
    pygame.display.flip()
    #print "UpdateTime '"+timeMode+"' done, "+datetime.datetime.now().strftime("%X")

#Display
#################################################

class refreshDisplay():
 def __init__(self):
  # Add a startup timer to run on the next full minute
  gobject.timeout_add_seconds(60-datetime.datetime.now().second, self.singletimer_cb) #Our 2nd main timer, running once per minute at 00

 def singletimer_cb(self):
  # Runs the first time the clock reaches 00 seconds
  global d, timeMode
  gobject.timeout_add_seconds(60, self.minutetimer_cb)
  d.UpdateTime(timeMode, True)
  return False

 def minutetimer_cb(self):
  #Recurring timer, once every minute
  global d, timeMode
  d.UpdateTime(timeMode, False)
  return True

#################################################
def quit():
 #Safe current mode before exiting
 global timeMode
 conf_client = gconf.client_get_default()
 conf_client.add_dir("/apps/tomch.com/mClock/general", gconf.CLIENT_PRELOAD_NONE)
 conf_client.set_string("/apps/tomch.com/mClock/general/timeMode", timeMode)

################################################# 
def switchMode():
  #Switch between display modes
  global timeMode
  if(timeMode=="maxi"):
    timeMode="mini"
  else:
    timeMode="maxi"
  d.UpdateTime(timeMode, True)

def switchEvent(widget, event):
   switchMode()

################################################# 
def main():

 global timeMode
 #load timeMode value from gconf
 conf_client = gconf.client_get_default()
 conf_client.add_dir("/apps/tomch.com/mClock/general", gconf.CLIENT_PRELOAD_NONE)
 timeModeStored = conf_client.get_string("/apps/tomch.com/mClock/general/timeMode")
 if(timeModeStored!="maxi" and timeModeStored!="mini"):
  conf_client.set_string("/apps/tomch.com/mClock/general/timeMode", "maxi")
  timeModeStored = "maxi"
 timeMode = timeModeStored
 #timeMode = "maxi"  #override for debugging
 
 global d
 d = display()
 global t
 t = refreshDisplay()

 d.UpdateTime(timeMode, True)

 #Quit on ESC
 accelgroup = gtk.AccelGroup()
 key, modifier = gtk.accelerator_parse('Escape')
 accelgroup.connect_group(key,modifier,gtk.ACCEL_VISIBLE,gtk.main_quit)
 window.add_accel_group(accelgroup)

 #Switchmode on touch
 window.add_events(gtk.gdk.KEY_PRESS_MASK | gtk.gdk.BUTTON_PRESS_MASK)
 window.connect('button-press-event', switchEvent)  
 window.connect('key-press-event', switchEvent)  

 gtk.main()
 
 quit()
 
#################################################      
if __name__ == '__main__':
 main()


