#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import dateutil.relativedelta

def end_of_month(d):
  return d+dateutil.relativedelta.relativedelta(day=31)

def start_of_month(d):
  return d+dateutil.relativedelta.relativedelta(day=1)

def nb_days_in_month(d):
  return ((end_of_month(d) - start_of_month(d)).days)+1

def first_weeknum_in_month(d):
  return int(start_of_month(d).strftime('%W'))

def weekday_of_first_day_in_month(d):
  return start_of_month(d).weekday()

