#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import time
#import mcalendar_framework
from mcalendar_framework import *
import commands
import gdata
import gdata.calendar.service
import gdata.service
import atom.service
import gdata.calendar
import socket
import urllib
import string
import dateutil
import dateutil.tz
import dateutil.parser

class GCalendar(Calendar):
  def __init__(self,gcal_id):
    Calendar.__init__(self,gcal_id)

  def parse_google_start_datetime(self,gdatetime):
    ldatetime = dateutil.parser.parse(gdatetime)
    if ldatetime.tzinfo == None:
      ldatetime = ldatetime.replace(tzinfo=dateutil.tz.tzutc())
    ldatetime = ldatetime.astimezone(dateutil.tz.tzutc())
#    ldatetime.astimezone(dateutil.tz.tzlocal())
#    if 'T' in gdatetime:
#      ldatetime = datetime.datetime.strptime(gdatetime[0:16], "%Y-%m-%dT%H:%M")
#    else:
#      ldatetime = datetime.datetime.strptime(gdatetime, "%Y-%m-%d")
#      ldatetime = ldatetime.replace(hour=0,minute=0,second=59)
    return ldatetime

  def parse_google_datetime(self,gdatetime):
    ldatetime = dateutil.parser.parse(gdatetime)
    ldatetime = ldatetime.replace(tzinfo=dateutil.tz.tzutc())
    return ldatetime

  def parse_google_end_datetime(self,gdatetime):
    ldatetime = dateutil.parser.parse(gdatetime)
    if ldatetime.tzinfo == None:
      ldatetime = ldatetime.replace(tzinfo=dateutil.tz.tzutc())
    ldatetime = ldatetime.astimezone(dateutil.tz.tzutc())
    #ldatetime.astimezone(dateutil.tz.tzlocal())
#    if 'T' in gdatetime:
#      ldatetime = datetime.datetime.strptime(gdatetime[0:16], "%Y-%m-%dT%H:%M")
#    else:
#      ldatetime = datetime.datetime.strptime(gdatetime, "%Y-%m-%d")
#      ldatetime = ldatetime.replace(hour=23,minute=59,second=59)
#      diff = datetime.timedelta(days=1)
#      ldatetime = ldatetime - diff
    return ldatetime

  def import_google_event(self,local_event,distant_event):          
    for a_when in distant_event.when:
      local_event.start_datetime = self.parse_google_start_datetime(a_when.start_time)
      local_event.end_datetime = self.parse_google_end_datetime(a_when.end_time)
    local_event.description = distant_event.text
    local_event.title = distant_event.title.text
    if local_event.title == None:
      local_event.title = local_event.description
    if local_event.description == None:
      local_event.description = local_event.title
    local_event.google_event_id = distant_event.id.text
    local_event.google_cal_id = self.gcal_id
    local_event.lastup = self.parse_google_datetime(distant_event.updated.text)
#    local_event.last_update = local_event.last_update + datetime.timedelta(seconds = 1)
    if distant_event.recurrence == None:
      local_event.repeat = False
    else:
      local_event.repeat = True
      rstring = distant_event.recurrence.text
      rstring = rstring.split('\n')
      if len(rstring[2]) != 0 :
        for line in rstring:
          if 'DTSTART' in line:
            value = line.split(':')[1]
            local_event.start_datetime = self.parse_google_start_datetime(value)
          elif 'DTEND' in line:
            value = line.split(':')[1]
            local_event.end_datetime = self.parse_google_end_datetime(value)
          if "RRULE" in line:
            local_event.repeat_rule = line
    for participant in distant_event.who:
      if participant.attendee_status != None:
        local_event.who.append(Attendee(participant.email,participant.name,participant.attendee_status.value))
#        LogIt().append('DEBUG:'+str(participant.attendee_status.value))
#    print 'Imported event : '+str(local_event.title)+' at :'+str(local_event.start_datetime)+' uuid :'+ str(local_event.uuid)
    LogIt().append('Imported event : '+str(local_event.title)+' at :'+str(local_event.start_datetime)+' uuid :'+ str(local_event.uuid))
    local_event.save_to_db()

class GSync:
  def __init__(self,login,password):
    self.login = login
    self.password = password
    self.cal_client = None
    self.errors = []
    self.current_status = "Google sync ..."

  def get_last_error(self):
    if len(self.errors)!=0:
      return self.errors[len(self.errors)-1]
    else:
      return None

  def convert_local_datetime(self,ldatetime,format=0):
    #ldatetime = datetime.datetime(ldatetime,tzinfo=dateutil.tz.tzlocal())
    #ldatetime = ldatetime.astimezone(dateutil.tz.tzoffset(None, 0))
    if format==0:
      return ldatetime.strftime("%Y-%m-%dT%H:%M:%S.000Z")
    elif format==1:
      return ldatetime.strftime("%Y%m%dT%H%M00Z")
    elif format==2:
      return ldatetime.strftime("%Y%m%d")

  def parse_google_datetime(self,gdatetime):
    ldatetime = dateutil.parser.parse(gdatetime)
    ldatetime = ldatetime.replace(tzinfo=dateutil.tz.tzutc())
    return ldatetime

  def connect(self):
    try:
#      print 'Connecting (Erzatz)...'
      LogIt().append('Try to connect...')
      self.cal_client = gdata.calendar.service.CalendarService()
      self.cal_client.source = 'mCalendar ' + FRAMEWORK_VERSION
#      self.cal_client.source = 'Nokian95'
      self.cal_client.additional_headers['User-Agent'] = 'Nokian95'
      self.cal_client.email = self.login
      self.cal_client.password = self.password
      self.cal_client.ProgrammaticLogin()  
#      print 'Connected.'
      LogIt().append('Connected to google')
      return True
    except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
      import traceback
      trace = str(traceback.print_exc())
      self.errors.append('While connecting to google calendar:\n'+str(error) + "\n" + trace)
      LogIt().append('While connecting to google calendar:\n'+str(error) + "\n" + trace)
      return False

  def get_gcal_list(self):
    gcal_list = []
    db = Database(DB_PATH)
    db.cursor.execute('SELECT id FROM google_cal;')
    for cal_id in db.cursor.fetchall():
      gcal_list.append(GCalendar(cal_id[0]))
    db.close()
    return gcal_list

  def refresh_gcal_list(self):
#    print 'Refreshing GCal list'
    LogIt().append('Refreshing GCal list')
    if (self.connect()==True):        
      try:
        gcal_feed = self.cal_client.GetCalendarListFeed()
        for gcal_in_feed in gcal_feed.entry:
          gcal = GCalendar(urllib.unquote(gcal_in_feed.id.text.split('/').pop())) 
          #gcal.last_update = self.parse_google_datetime(gcal_in_feed.updated.text)
          gcal.color = gcal_in_feed.color.value
          gcal.acces_level = gcal_in_feed.access_level.text
          gcal.save_to_db()
      except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
        import traceback
        trace = str(traceback.print_exc())
        self.errors.append('Getting calendar list on google :\n' + str(error) + "\n" + trace)
        LogIt().append('Error occur while getting calendar list on google :\n' + str(error) + "\n" + trace)
    LogIt().append('GCal list refreshed')

  def sync_events_new(self):
#    print 'Syncing new events'
    LogIt().append('Syncing new events')
    uuid_list = EventList().get_event_new()
    for local_event_uuid in uuid_list:
      local_event = Event(local_event_uuid)
#      print 'Uploading event : ' + local_event.title
      LogIt().append('Uploading new event')
      try:
        distant_event = gdata.calendar.CalendarEventEntry()
        distant_event.author.append(atom.Author(name=atom.Name(text='mCalendar')))
        distant_event.title = atom.Title(text=local_event.title)
        if local_event.description != None:
          distant_event.content = atom.Content(text=local_event.description.encode())
        if local_event.repeat==True:
          recurrence_data = 'DTSTART;TZID=Etc/GMT:'+self.convert_local_datetime(local_event.start_datetime,1)+'\r\n' + 'DTEND;TZID=Etc/GMT:'+self.convert_local_datetime(local_event.end_datetime,1)+'\r\n' + local_event.repeat_rule
          recurrence_data = recurrence_data + '\r\n'
          distant_event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
          distant_event.when.append(gdata.calendar.When(start_time=self.convert_local_datetime(local_event.start_datetime), end_time=self.convert_local_datetime(local_event.end_datetime)))              
        else:
          distant_event.when.append(gdata.calendar.When(start_time=self.convert_local_datetime(local_event.start_datetime), end_time=self.convert_local_datetime(local_event.end_datetime)))
        for attendee in local_event.who:
          distant_event.who.append(gdata.calendar.Who(email=attendee.email,name=attendee.name,statut=attendee.statut))
#          distant_attendee = gdata.calendar.Who()
#          distant_attendee.name = attendee.name
#          distant_attendee.email = attendee.email
#          distant_event.who.append(attendee)
        print local_event.google_cal_id
        print ('/calendar/feeds/'+local_event.google_cal_id+'/private/full').decode()

        new_distant_event = self.cal_client.InsertEvent(distant_event,('http://www.google.com/calendar/feeds/'+local_event.google_cal_id+'/private/full').decode())
        local_event.google_event_id = new_distant_event.id.text
        local_event.google_cal_id = urllib.unquote(new_distant_event.id.text.split('/')[5])  
        local_event.save_to_db()
        LogIt().append('Uploaded event : ' + str(local_event.title))
      except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
        import traceback
        trace = str(traceback.print_exc())
        self.errors.append('Sending new local event on google :\n' + str(error) + "\n" + trace)
        LogIt().append('Error while dending new local event on google :\n' + str(error) + "\n" + trace)
        self.connect()
    LogIt().append('New events uploaded')

  def sync_events_localy_updated(self,gcal):
    LogIt().append('Updating events to google')
#    gcal.last_update = gcal.last_update.replace(tzinfo=dateutil.tz.tzutc())
    uuid_list = EventList().get_event_not_updated_since(gcal.last_update)
#    LogIt().append('DEBUG:localy_updated:'+str(gcal.last_update))
    for local_event_uuid in uuid_list:
      local_event = Event(local_event_uuid)
      try:
        distant_event = self.cal_client.GetCalendarEventEntry(local_event.google_event_id)
        distant_event.author.append(atom.Author(name=atom.Name(text='mCalendar')))
        distant_event.title = atom.Title(text=local_event.title)
        distant_event.content = atom.Content(text=local_event.description.encode())
        if local_event.repeat==True:
          recurrence_data = 'DTSTART;TZID=Etc/GMT:'+self.convert_local_datetime(local_event.start_datetime,1)+'\r\n' + 'DTEND;TZID=Etc/GMT:'+self.convert_local_datetime(local_event.end_datetime,1)+'\r\n' + local_event.repeat_rule
          recurrence_data = recurrence_data + '\r\n'
          distant_event.recurrence = gdata.calendar.Recurrence(text=recurrence_data)
          distant_event.when.append(gdata.calendar.When(start_time=self.convert_local_datetime(local_event.start_datetime), end_time=self.convert_local_datetime(local_event.end_datetime)))              
        else:
          distant_event.when.append(gdata.calendar.When(start_time=self.convert_local_datetime(local_event.start_datetime), end_time=self.convert_local_datetime(local_event.end_datetime)))
        for attendee in local_event.who:
          distant_event.who.append(gdata.calendar.Who(email=attendee.email,name=attendee.name))
        distant_event.updated.text = self.convert_local_datetime(local_event.lastup)
        edit_link = distant_event.GetEditLink()
        if edit_link != None:
          distant_event = self.cal_client.UpdateEvent(edit_link.href, distant_event)
        local_event.google_event_id = distant_event.id.text
        local_event.google_cal_id = urllib.unquote(local_event.google_event_id.split('/')[5])  
        local_event.save_to_db()
        LogIt().append('Downloaded event : ' + str(local_event.title))
      except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
        import traceback
        trace = str(traceback.print_exc())
        self.errors.append('Updating local event on google :\n' + str(error) + "\n" + trace)
        LogIt().append('Error while Updating local event on google :\n' + str(error) + "\n" + trace)
        self.connect()
    LogIt().append('Google events updated')

  def sync_events_googly_updated(self,gcal):
    LogIt().append('Retrieving updated event from google')
    query_index = 1
    query_no_more_result = False

#    print 'sync calid:' + str(gcal.gcal_id) + 'last_update:' + str(gcal.last_update)

    while(query_no_more_result == False):
      try:
        query = gdata.calendar.service.CalendarEventQuery(gcal.gcal_id, 'private', 'composite', None, {"ctz":"utc"})
        gcal.last_update = gcal.last_update.replace(tzinfo=dateutil.tz.tzlocal())
        query.updated_min = self.convert_local_datetime(gcal.last_update.astimezone(dateutil.tz.tzutc()))
#        LogIt().append('DEBUG:query.updated_min:'+str(query.updated_min))
#        query.updated_min = self.convert_local_datetime(datetime.datetime(2008,10,10,0,0,0))
        query.max_results = 1
        query.start_index = str(query_index)
        print query_index
        feed = self.cal_client.CalendarQuery(query)

        if len(feed.entry)<1:
#          print 'No more result'
          query_no_more_result = True
        else:
          #TODO
          LogIt().append('Importing event...')
          for i, distant_event in enumerate(feed.entry):
            distant_event.id.text = string.replace(distant_event.id.text,'composite','full')
            local_event = Event()
            local_event.google_event_id = distant_event.id.text
#            print 'googleid:' + str(distant_event.id.text)
            local_event.load_event_from_google_id()
            if distant_event.event_status.value=='CANCELED':
              local_event.delete_from_db()
#              print 'Events deleted on google'
            else:
              if local_event.new == True:
#                print 'Import new event from google'
                gcal.import_google_event(local_event,distant_event)
              else:
                distant_last_update = self.parse_google_datetime(distant_event.updated.text)
#                distant_last_update = distant_last_update + datetime.timedelta(seconds = 1)
                if distant_last_update==local_event.lastup:
                  pass
#                  print 'Events match %s' % (local_event.uuid)
                elif distant_last_update<local_event.lastup:
                  pass
#                  print 'warning local event newer'
#                  print 'should not happen !!!!'
#                  print 'should not happen !!!!'
#                  print 'should not happen !!!!'
#                  print 'should not happen !!!!'
                elif distant_last_update>local_event.lastup:
#                  print 'Import one event'
#                  print 'distant datetime:'+str(distant_last_update)
#                  print 'local datetime:'+str(local_event.lastup)

                  gcal.import_google_event(local_event,distant_event)

      except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
        import traceback
        trace = str(traceback.print_exc())
        self.errors.append("Error while retrieving an event"+str(error) + "\n" + trace+ "\n")
        LogIt().append("Error while retrieving an event"+str(error) + "\n" + trace+ "\n")
        cal_client = self.connect()

      query_index = query_index + 1

    LogIt().append('Local events updated by google')

  def sync_events_deleted(self,gcal):
    LogIt().append('Deleting event on google')
    uuid_list = EventList().get_event_deleted()
    for local_event_uuid in uuid_list:
      local_event = Event(local_event_uuid)
      try:
        distant_event = self.cal_client.GetCalendarEventEntry(local_event.google_event_id)
        if distant_event.GetEditLink()!=None:
          self.cal_client.DeleteEvent(distant_event.GetEditLink().href)
          local_event.google_event_id = ''
          local_event.delete_from_db()

      except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
        import traceback
        trace = str(traceback.print_exc())
        self.errors.append('Deleting event on google :\n' + str(error) + "\n" + trace)
        LogIt().append('Error while deleting event on google :\n' + str(error) + "\n" + trace)
        self.connect()
    LogIt().append('Event from google deleted')

  def sync_events(self):
    if (self.connect()==True):
      gcal_list = self.get_gcal_list()
      for gcal in gcal_list:
        if gcal.to_sync == True:
          error_level = len(self.errors)
          self.sync_events_deleted(gcal)
          self.sync_events_localy_updated(gcal)          
          self.sync_events_googly_updated(gcal)
          self.sync_events_new()

          if error_level == len(self.errors):
            gcal.last_update = datetime.datetime.now()
            gcal.save_to_db()

      if len(gcal_list)==0:
        self.errors.append('No calendar to sync')
        LogIt().append('No calendar to sync')

    LogIt().append('Sync finished')

if __name__ == "__main__":
  import mcalendar_prefs
  LogIt().append('Launching autosync')
  prefs = mcalendar_prefs.mPrefs()
  sync = GSync(str(prefs.get_value('google_login')).encode(),str(prefs.get_value('google_password')).encode())
  sync.refresh_gcal_list()
  sync.sync_events()