import gtk
import cairo
import pango
import pangocairo
import hildon
import datetime
import dateutil

class AgendaView(gtk.DrawingArea):

  def __init__(self):
    gtk.DrawingArea.__init__(self)
    self.eventsList = []
    self.current_date = datetime.date(2009,3,1)
    self.start_hour = 9
    self.end_hour = 19
    self.mode = 2
    self.callback= None
    #0 -> Day
    #1 -> Week
    #2 -> Month
    self.connect("expose_event", self.expose)
    self.connect("button_press_event", self.button_press_event)
    self.set_events(gtk.gdk.EXPOSURE_MASK |
        gtk.gdk.LEAVE_NOTIFY_MASK |
        gtk.gdk.BUTTON_PRESS_MASK |
        gtk.gdk.POINTER_MOTION_MASK |
        gtk.gdk.POINTER_MOTION_HINT_MASK)  

  def expose(self, widget, event):
    self.context = widget.window.cairo_create()
    # set a clip region for the expose event
    self.context.rectangle(event.area.x, event.area.y,
                           event.area.width, event.area.height)
    self.context.clip() 
    self.draw(self.context)
    return False

  def draw(self, context):
    rect = self.get_allocation()
    self.rect = rect
    if self.mode == 0:
      self.draw_header(context,rect)
      self.draw_events(context,rect)
    elif self.mode == 1:
      self.draw_header(context,rect)
      self.draw_sub_header(context,rect)
      self.draw_week_hours(context,rect)
      self.draw_events(context,rect)
    elif self.mode == 2:
      self.draw_header(context,rect)
      self.draw_sub_header(context,rect)
      self.draw_events(context,rect)

  def draw_week_hours(self,context,rect):
    for index in range(self.end_hour-self.start_hour):
      h = self.start_hour + index
      y = ((((h*60)-(self.start_hour*60))*(rect.height - 50))/(((self.end_hour-self.start_hour)*60)))+51
      context.move_to(24,y)
      context.set_source_rgb(0.9, 0.9, 0.9)
      context.set_line_width(1.0)
      context.line_to(rect.width-4,y)
      context.stroke()
      pangocontext = pangocairo.CairoContext(context)
      layout = pangocontext.create_layout()
      layout.set_font_description(pango.FontDescription('Monospace 10'))
      layout.set_markup(str(h))
      context.set_source_rgb(0.0, 0.0, 0.0)
      context.move_to(0, y-7)
      pangocontext.update_layout(layout)
      pangocontext.show_layout(layout)    

  def draw_sub_header(self,context,rect):
    if self.mode==0:
      pass
    elif self.mode == 1:
      for i in range(7):
        xstart = int(((rect.width-24)/7)*i)+24
        xend = int(((rect.width-24)/7)*(i+1))+24

        context.set_source_rgb(0.7, 0.7, 0.7)
        context.move_to(xstart-1,27)
        context.line_to(xstart-1,rect.height-27)
        context.set_line_width(1.0)
        context.stroke()

        context.set_source_rgb(0.09, 0.20, 0.25) #064163
        context.rectangle(xstart,27,xend-xstart-1,25)
        context.fill()

        context.set_source_rgb(1.0, 1.0, 1.0)
        pangocontext = pangocairo.CairoContext(context)
        layout = pangocontext.create_layout()
        layout.set_font_description(pango.FontDescription('Monospace 10'))
        diff = datetime.timedelta(days=i)
        layout.set_markup((self.current_date+diff).strftime('%A %d'))
        context.move_to(xstart+2, 31)
        pangocontext.update_layout(layout)
        pangocontext.show_layout(layout)    

      context.set_source_rgb(0.7, 0.7, 0.7)
      context.move_to(xend,27)
      context.line_to(xend,rect.height-27)
      context.stroke()

    elif self.mode==2:
      for i in range(7):
        xstart = int(((rect.width-24)/7)*i)+24
        xend = int(((rect.width-24)/7)*(i+1))+24

#        context.set_source_rgb(0.7, 0.7, 0.7)
#        context.move_to(xstart-1,27)
#        context.line_to(xstart-1,rect.height-27)
#        context.set_line_width(1.0)
#        context.stroke()

        context.set_source_rgb(0.09, 0.20, 0.25) #064163
        context.rectangle(xstart,27,xend-xstart-1,25)
        context.fill()

        context.set_source_rgb(1.0, 1.0, 1.0)
        pangocontext = pangocairo.CairoContext(context)
        layout = pangocontext.create_layout()
        layout.set_font_description(pango.FontDescription('Monospace 10'))
        diff = datetime.timedelta(days=i-self.current_date.weekday())
        layout.set_markup((self.current_date+diff).strftime('%A'))
        context.move_to(xstart+2, 31)
        pangocontext.update_layout(layout)
        pangocontext.show_layout(layout)    

#      context.set_source_rgb(0.7, 0.7, 0.7)
#      context.move_to(xend,27)
#      context.line_to(xend,rect.height-27)
#      context.stroke()
      pass
    else:
      pass

  def draw_header(self,context,rect):
    context.rectangle(rect.x,rect.y,rect.width,rect.height)
    context.set_source_rgb(1.0, 1.0, 1.0)
    context.fill()

    context.rectangle(rect.x,rect.y,rect.width,25)
    context.set_source_rgb(0.4706, 0.5765, 0.7098) #7893B5
    context.fill()

    #Draw the day / week / month title
    context.set_source_rgb(1.0, 1.0, 1.0)
    pangocontext = pangocairo.CairoContext(context)
    layout = pangocontext.create_layout()
    layout.set_font_description(pango.FontDescription('Monospace 12'))
    if self.mode==0:
      layout.set_markup(self.current_date.strftime('<b>%A %x</b>'))
    elif self.mode==1:
      layout.set_markup(self.current_date.strftime('<b>Week %W %B %Y</b>'))
    elif self.mode==2:
      layout.set_markup(self.current_date.strftime('<b>%B %Y</b>'))
    else:
      layout.set_markup(self.current_date.strftime('<b>%A %x</b>'))
    context.move_to(2, 2)
    pangocontext.update_layout(layout)
    pangocontext.show_layout(layout)

  def draw_events(self,context,rect):

    if self.mode == 2:
      day_displayed = self.current_date.replace(day=1)
      month_displayed = day_displayed.month
      diff = datetime.timedelta(days=1) 
      line = 0
      while day_displayed.month == month_displayed:
        wkday = day_displayed.weekday()
        xstart = int(((rect.width-24)/7)*wkday)+24
        xend = int(((rect.width-24)/7)*(1+wkday))+22
        ystart = ((line*(rect.height - 54))/6)+54
        yend = (((line+1)*(rect.height - 54))/6)+54
        if wkday == 6:
          line = line + 1
        #Draw the rect bg
        context.rectangle(xstart,ystart,xend-xstart+1,yend-ystart+1)
        context.set_source_rgb( 0.9,0.9,0.9)
        context.stroke()
        #Test if day in eventlist
        for (day,event) in self.eventsList:
          if day_displayed.date() == day.astimezone(dateutil.tz.tzlocal()).date(): 
            context.rectangle(xstart+1,ystart+1,xend-xstart-1,yend-ystart-1)
            context.set_source_rgb( 0.9,0.9,0.9)
            context.fill()

        #Draw the month label
        context.set_source_rgb(0.0, 0.0, 0.0)
        pangocontext = pangocairo.CairoContext(context)
        layout = pangocontext.create_layout()
        layout.set_font_description(pango.FontDescription('Monospace 10'))
        layout.set_markup(str(day_displayed.day))
        context.move_to(xstart+2, ystart+5)
        pangocontext.update_layout(layout)
        pangocontext.show_layout(layout)

        day_displayed = day_displayed + diff

    elif self.mode in (0,1):
      for date,event in self.eventsList:
        print event.title
        #Calc Pos Ystart
        h = event.start_datetime.astimezone(dateutil.tz.tzlocal()).hour
        m = event.start_datetime.astimezone(dateutil.tz.tzlocal()).minute
        if (h<self.start_hour):
          h = self.start_hour
          m = 0
        print 'rect.height:'+str(rect.height)
        ystart = ((((h*60+m)-(self.start_hour*60))*(rect.height - 50))/(((self.end_hour-self.start_hour)*60)))+50
  #      ystart = (((h*60 + m)/1440) * (rect.height - 50))+50
        #Calc Pos Yend
        h = event.end_datetime.astimezone(dateutil.tz.tzlocal()).hour
        m = event.end_datetime.astimezone(dateutil.tz.tzlocal()).minute
        if (h>=self.end_hour):
          h = self.end_hour-1
          m = 0
          ystart = ((((h*60+m)-(self.start_hour*60))*(rect.height - 50))/(((self.end_hour-self.start_hour)*60)))+50
        yend = ((((h*60+m)-(self.start_hour*60))*(rect.height - 50))/(((self.end_hour-self.start_hour)*60)))+50
  #      yend = (((h*60 + m)/1440) * (rect.height - 50))+50
        #Calc Pos XStart
        if self.mode == 0 :
          xstart = 2
          xend = rect.width-2
        elif self.mode == 1 :
  #        xstart = 5 + (position*95) + 2
  #        xend = 100 + (position*95) - 2
          print 'current:'+str(self.current_date.date())
          print 'event:'+str(event.start_datetime.astimezone(dateutil.tz.tzlocal()).date())
          i = (date.astimezone(dateutil.tz.tzlocal()).date()-self.current_date.date()).days
          xstart = int(((rect.width-24)/7)*i)+24
          xend = int(((rect.width-24)/7)*(i+1))+22

        print str(xstart)+':'+str(ystart)+':'+str(xend-xstart)+':'+str(yend-ystart)
        context.rectangle(xstart,ystart,xend-xstart,yend-ystart)
        c = gtk.gdk.color_parse(event.get_fg_color())
        context.set_source_rgb( float(c.red) / 65535, float(c.green) / 65535, float(c.blue) / 65535)
        context.fill()

        context.rectangle(xstart,ystart,xend-xstart,25)
        context.set_source_rgb(0.4706, 0.5765, 0.7098) #7893B5
        context.fill()

        #Draw the day / week / month title
        context.set_source_rgb(1.0, 1.0, 1.0)
        pangocontext = pangocairo.CairoContext(context)
        layout = pangocontext.create_layout()
        layout.set_font_description(pango.FontDescription('Monospace 10'))
        layout.set_markup(event.start_datetime.astimezone(dateutil.tz.tzlocal()).strftime('%H:%M')+'-'+event.end_datetime.astimezone(dateutil.tz.tzlocal()).strftime('%H:%M'))
        context.move_to(xstart+2, ystart+5)
        pangocontext.update_layout(layout)
        pangocontext.show_layout(layout)

        #Draw description if there is enought place
        if (ystart+45)<yend:
          context.set_source_rgb(0.0, 0.0, 0.0)
          pangocontext = pangocairo.CairoContext(context)
          layout = pangocontext.create_layout()
          layout.set_font_description(pango.FontDescription('Monospace 9'))
          if len(event.title)>13:
            title = event.title[0:10]+'...'
          else:
            title = event.title
          layout.set_markup(title)
          context.move_to(xstart+2, ystart+25)
          pangocontext.update_layout(layout)
          pangocontext.show_layout(layout)

  def button_press_event(self,widget, event):
    if event.button == 1:
      print 'Click:'+str(event.x)+':'+str(event.y)

      if self.mode == 2:
        col = int((event.x-24)/((self.rect.width-24)/7))
        line = int(((event.y-54)/((self.rect.height-54)/6)))
        day = col + (line * 7) - self.current_date.weekday()
        diff = datetime.timedelta(days=day)
        date = self.current_date + diff
        print 'Date:' + str(date)
      if self.mode == 1:
        col = int((event.x-24)/((self.rect.width-24)/7))
        diff = datetime.timedelta(days=col)
        date = self.current_date + diff
        print 'Date:' + str(date)
      if self.callback !=None:
        self.callback(date)
    return True

def main():
  window = hildon.Window()
  window.fullscreen()
  clock = AgendaView()

  window.add(clock)
  window.connect("destroy", gtk.main_quit)
  window.show_all()

  gtk.main()

if __name__ == "__main__":
  main()
