#include "settingswindow.h"
#include "ui_settingswindow.h"
#include "maemobarcodewindow.h"
#include "videowidget.h"
#include "barcodedetector.h"
#include <QDebug>

SettingsWindow::SettingsWindow(MaemoBarcodeWindow *parent) :
    QMainWindow(parent),
    ui(new Ui::SettingsWindow)
{
    ui->setupUi(this);
    setAttribute(Qt::WA_Maemo5StackedWindow);
    this->parent = parent;
    this->settings = parent->settings;
}

SettingsWindow::~SettingsWindow()
{
    delete ui;
}

void SettingsWindow::hideEvent(QHideEvent *) {
    settings->setValue("save_history", ui->chkSaveHistory->isChecked());
    settings->setValue("use_autofocus", ui->chkAutofocus->isChecked());
    settings->setValue("use_full_screen", ui->chkFullScreen->isChecked());
    settings->setValue("autofocus_delay", ui->spnAutoFocusDelay->value());
    settings->setValue("continous_scanning", ui->radioButtonContinuousScanning->isChecked());
    if(ui->chkFullScreen->isChecked()) {
        parent->showFullScreen();
    } else {
        parent->showNormal();
    }
    if(ui->chkAutofocus->isChecked()) {
        parent->videoWidget->refocusTimer->start();
    } else {
        parent->videoWidget->refocusTimer->stop();
    }

    if (ui->radioButtonContinuousScanning->isChecked()){
        parent->continuousScanningMode = true;
        parent->videoWidget->setContinuousScanning(true);
    }else{
        parent->continuousScanningMode = false;
        parent->videoWidget->setContinuousScanning(false);
    }

//    settings->sync(); // Not necessary to call, it is called automatically.
}

void SettingsWindow::showEvent(QShowEvent *) {
    qDebug() << "SettingsWindow::SettingsWindow(): Setting initial settings";
    ui->chkSaveHistory->setChecked(settings->value("save_history", true).toBool());
    ui->chkAutofocus->setChecked(settings->value("use_autofocus", true).toBool());
    ui->chkFullScreen->setChecked(settings->value("use_full_screen", true).toBool());
    ui->spnAutoFocusDelay->setValue(settings->value("autofocus_delay", 2.0).toDouble());
    ui->radioButtonContinuousScanning->setChecked(settings->value("continous_scanning", CONTINUOUS_SCANNING_DEFAULT).toBool());
    ui->radioButtonPressToScan->setChecked(!settings->value("continous_scanning", CONTINUOUS_SCANNING_DEFAULT).toBool());
}

void SettingsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsWindow::on_chkSaveHistory_clicked()
{
    //settings->setValue("save_history", ui->chkSaveHistory->isChecked());
}

void SettingsWindow::on_spnAutoFocusDelay_valueChanged(double value)
{
    //settings->setValue("autofocus_delay", ui->spnAutoFocusDelay->value());
}

// this is done automatically for us :)
void SettingsWindow::on_radioButtonContinuousScanning_clicked()
{
    //ui->radioButtonPressToScan->setChecked(false);
}

void SettingsWindow::on_radioButtonPressToScan_clicked()
{
    //ui->radioButtonContinuousScanning->setChecked(false);
}
