//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#include <QtGui/QApplication>
#include <QtDBus>
#include <QSplashScreen>
#include <QPixmap>
#include "maemobarcodewindow.h"

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    qDebug() << "main(): Started mbarcode";

    qDebug() << "main(): Showing splash";
    QPixmap pixmap(":/images/splash.png");
    QSplashScreen splash(pixmap);
    splash.show();
    a.processEvents();

    qDebug() << "main(): Showing window";
    MaemoBarcodeWindow w;

    if (!QDBusConnection::sessionBus().isConnected()) {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }

    if (!QDBusConnection::sessionBus().registerService("org.maemo.mbarcode")) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(2);
    }

    if (!QDBusConnection::sessionBus().registerObject("/org/maemo/mbarcode", &w,
            QDBusConnection::ExportScriptableSlots | QDBusConnection::ExportScriptableSignals)) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(3);
    }

    if(w.settings->value("use_full_screen", true).toBool()) {
        w.showFullScreen(); // showFullScreen increases performance drastically using openGL - loses menus though...
    } else {
        w.show();
    }
    // there is no reason to why the scanning should not be performed in fullscreen.
    // When not scanning, however, it might be useful to have access to the menu (multitasking for instance).
    return a.exec();
}
