#include <QWidget>
#include <QThread>
#include "dmtxdecoderthread.h"
#include <QWaitCondition>
#include <qmutex.h>
#include <dmtx.h>
#include <iostream>

#include "common.h"

using namespace std;

DMTXDecoderThread::DMTXDecoderThread()
{
    this->frame_width = WIDTH; // not really necessary as these won't change during the program
    this->frame_height = HEIGHT;
    this->thread_buffer = (char*)malloc(this->frame_width*this->frame_height*sizeof(char)*4); // need to account for bpp here, but let's assume 32bit pp is the maximum

    thread_output=0;
    hasFoundBarcode=false;
    doQuit=false;
    isDecoding=false;

}

DMTXDecoderThread::~DMTXDecoderThread()
{
    this->doQuit=true;
    this->thread_run.wakeOne();
}


void DMTXDecoderThread::run()
{
    while(true){

        // this allows the main program to block us until data is available for us
        //this->wait_mutex.lock();
        this->thread_run.wait(&this->wait_mutex); // wait here until signalled
        //this->wait_mutex.unlock();

        // see if we should quit
        if(this->doQuit==true){
            free(this->thread_buffer);
            return;
        }

        // call our function
        this->wait_mutex.lock();
        this->isDecoding=true;
        this->hasFoundBarcode = libdmtx_analyse_image();
        this->isDecoding=false;
        this->wait_mutex.unlock();

        // return data in our global vars
        // reset our timer, hopefully this should be threadsafe, etc...

    }

}


/* Analyse the image data */
int DMTXDecoderThread::libdmtx_analyse_image()
{
    //GdkPixbuf *pixbuf = NULL;
    //GError *error = NULL;
    //unsigned int bpp;
    //const char *directory;
    //GString *filename;
    //unsigned int base_len, i;
    //struct stat statbuf;
    //int ret,ii;
    //int ean[14];
    //DmtxEncode     *enc;
    DmtxImage      *img;
    DmtxDecode     *dec;
    DmtxRegion     *reg;
    DmtxMessage    *msg;
    DmtxTime        timeout;

//    fprintf(stdout, "Entered libdmtx_analyse_image()\n");

    img = dmtxImageCreate((unsigned char*)thread_buffer, frame_width, frame_height, frame_fourcc); // DmtxPack8bppK
    //assert(img != NULL);
//    cout << "libdmtx_analyse_image(): done dmtxImageCreate" << endl;

    dec = dmtxDecodeCreate(img, 1);
    //assert(dec != NULL);
//    cout << "libdmtx_analyse_image(): done dmtxDecodeCreate" << endl;

    timeout = dmtxTimeAdd(dmtxTimeNow(), 1000); // give it 100 ms to analyse...
    reg = dmtxRegionFindNext(dec, &timeout);

//    cout << "libdmtx_analyse_image(): done dmtxRegionFindNext" << endl;
    if(reg != NULL) {
        msg = dmtxDecodeMatrixRegion(dec, reg, DmtxUndefined);
//        cout << "libdmtx_analyse_image(): done dmtxDecodeMatrixRegion" << endl;
        if(msg != NULL) {
            cout << "Found datamatrix barcode!" << endl;
            //fputs("output: \"", stdout);
            //fwrite(msg->output, sizeof(unsigned char), msg->outputIdx, stdout);
            //fputs("\"\n", stdout);

            if (thread_output){
                free(thread_output);
                thread_output=0;
            }

            thread_output = (char *)malloc((msg->outputIdx+1) * sizeof (char));
            memcpy(thread_output, msg->output, msg->outputIdx);
            thread_output[msg->outputIdx +1] = 0; // add the null terminator for the char array

            dmtxMessageDestroy(&msg);
            dmtxRegionDestroy(&reg);
            dmtxDecodeDestroy(&dec);
            dmtxImageDestroy(&img);
            return TRUE;
        }
        dmtxRegionDestroy(&reg);
    }

    dmtxDecodeDestroy(&dec);
    dmtxImageDestroy(&img);
    return FALSE;
}


