//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

// qt includes
#include <QtGui>
// local includes
#include "resultswindow.h"
#include "ui_resultswindow.h"
#include "pluginaction.h"
#include "plugininterfaces.h"
#include "pluginintermediate.h"

ResultsWindow::ResultsWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::ResultsWindow)
{
    ui->setupUi(this);
    checkTimer = new QTimer(this);
    connect(checkTimer, SIGNAL(timeout()),this,SLOT(checkPlugins()));
    setAttribute(Qt::WA_Maemo5StackedWindow);
    ui->tblResults->setItemDelegate(new PluginActionListDelegate(this));
    ui->tblResults->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
}

ResultsWindow::~ResultsWindow()
{
    delete ui;
}

void ResultsWindow::setPluginActions(QList<PluginAction *>plugins) {
    qDebug() << "ResultsWindow::setPluginActions(): Called.";
    this->plugins = plugins;
}
void ResultsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ResultsWindow::processBarcode(QString barcode) {
    if(barcode.length() > 40) {
        ui->lblResults->setText(tr("Results for '%1...'").arg(barcode.left(40)));
    } else {
        ui->lblResults->setText(tr("Results for '%1'").arg(barcode));
    }

    // save the barcode text
    this->barcode_text = QString(barcode);
    checkTimer->start(500); // check for updated plugins every x milliseconds
}
void ResultsWindow::checkPlugins() {
//    qDebug() << "Checking plugins";
    foreach(PluginAction* plugin, plugins) {
//        qDebug() << "Checking action plugin " << plugin->getName() << "is ready" << plugin->isReady();
        if(plugin->isReady() && !addedPlugins.contains(plugin)) { // check if it's ready and that it has not yet been added
            addedPlugins.append(plugin); // add it to the list of added plugins, so we don't add it twice
//            qDebug() << "Added plugin" << plugin->getText() << plugin->getName();
        }
    }
    QAbstractItemModel *oldModel = ui->tblResults->model();
    PluginActionListModel *model = new PluginActionListModel(this, addedPlugins);
    ui->tblResults->setModel(model);
    delete(oldModel);
    ui->tblResults->resizeRowsToContents();
    ui->tblResults->setFixedHeight(ui->tblResults->verticalHeader()->length() + 60); // fix to make all contents of scrollwidget scroll together
}

void ResultsWindow::on_pushButton_clicked()
{
    QApplication::clipboard()->setText(this->barcode_text, QClipboard::Clipboard);
}

QSize PluginActionListDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) {
    return QSize();
}

void PluginActionListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option,
                                     const QModelIndex &index) const {
    QStyledItemDelegate::paint(painter, option, index);

    PluginAction *e = qVariantValue<PluginAction *>(index.data());

    QFont font = option.font;
    QRect rect = option.rect;
    rect.adjust(65, 10, -20, -7);
    QRect irect = option.rect;
    irect.adjust(3, 10, -20, -7);

    painter->save();

    if(!e->getImage().isNull()) {
        painter->drawImage(QRect(irect.left(), irect.top(), 48, 48), e->getImage());
    }
    painter->drawText(rect, Qt::AlignTop | Qt::AlignLeft, e->getText());

    if(!e->getDataImage().isNull()) {
        painter->drawImage(QRect(rect.right() - 50, rect.top(), 48, 48), e->getDataImage());
    } else {
        painter->drawText(rect, Qt::AlignTop | Qt::AlignRight, e->getDataText());
    }
    painter->setPen(option.palette.mid().color());
    font.setPointSizeF(font.pointSizeF() * 0.70);
    painter->setFont(font);
    painter->drawText(rect, Qt::AlignBottom | Qt::AlignLeft, e->getInformativeText());

    painter->restore();
}

int PluginActionListModel::rowCount(const QModelIndex &) const {
    return plugin_list.size();;
}

QVariant PluginActionListModel::data(const QModelIndex &index, int role) const {
    if(!index.isValid())
        return QVariant();
    if(index.row() >= rowCount() || index.row() < 0) {
        return QVariant();
    }

    if(role == Qt::DisplayRole) {
        return qVariantFromValue(plugin_list.at(index.row()));
    }

    return QVariant();
}

void ResultsWindow::on_tblResults_clicked(QModelIndex index)
{
    PluginAction *plugin = qVariantValue<PluginAction*>(index.data());
    plugin->clickAction(this);
}
