#include <QWidget>
#include <QThread>
#include <QWaitCondition>
#include <qmutex.h>
#include <zbar.h>
#include "zbardecoderthread.h"
#include <iostream>

using namespace std;

ZBarDecoderThread::ZBarDecoderThread()
{
    this->frame_width = 320; // not really necessary as these won't change during the program
    this->frame_height = 240;
    this->thread_buffer = (char*)malloc(this->frame_width*this->frame_height*sizeof(unsigned char)*4); // need to account for bpp here, but let's assume 32bit pp is the maximum

    thread_output=0;
    hasFoundBarcode=false;
    doQuit=false;
    isDecoding=false;

    this->scanner = zbar_image_scanner_create();
    cout << "Created scanner" << endl;
    /* configure the reader */
    //zbar_image_scanner_set_config(scanner, NULL, ZBAR_CFG_ENABLE, 1);
    zbar_image_scanner_enable_cache(this->scanner, TRUE);
    cout << "Enabled scanner" << endl;
    this->image = zbar_image_create();
    cout << "Created image" << endl;

}

ZBarDecoderThread::~ZBarDecoderThread()
{
    this->doQuit=true;
    this->thread_run.wakeOne();
}


void ZBarDecoderThread::run()
{
    while(true) {

//        cout << "ZBarDecoderThread::run(): in while loop" << endl;

        // this allows the main program to block us until data is available for us
        //this->wait_mutex.lock();
        this->thread_run.wait(&this->wait_mutex); // wait here until signalled
        //this->wait_mutex.unlock();

//        cout << "ZBarDecoderThread::run(): just gone past wait" << endl;

        // see if we should quit
        if(this->doQuit==true){
            cout << "ZBarDecoderThread::run(): doQuit=true" << endl;
            free(this->thread_buffer);
            return;
        }

        // call our function
        this->wait_mutex.lock(); // lock to make sure this is not set anywhere else
        this->isDecoding=true; // let the world know that we are decoding
        this->hasFoundBarcode = libzbar_analyse_image(); // do some work
        this->isDecoding=false; // let the world know that we are done
        this->wait_mutex.unlock(); // unlock, see above


//        cout << "ZBarDecoderThread::run(): just returned from libzbar_analyse_image(): "<< this->hasFoundBarcode << endl;


    }

}


/* Analyse the image data */
int ZBarDecoderThread::libzbar_analyse_image()
{

    zbar_image_set_format(image, *(int*)frame_fourcc); //*(int*)"Y800");
    zbar_image_set_size(image, frame_width, frame_height);
    zbar_image_set_data(image, thread_buffer, frame_width * frame_height * frame_bpp/8, NULL); //zbar_image_free_data

    /* scan the image for barcodes */
    int n = zbar_scan_image(scanner, image);

    if(n) {
        /* extract results */
        const zbar_symbol_t *symbol = zbar_image_first_symbol(image); // only use the first symbol
        zbar_symbol_type_t typ = zbar_symbol_get_type(symbol);
        fprintf(stdout, "Extracting symbols :)");

        const char* temp = zbar_symbol_get_data(symbol);
        if(thread_output){
            free(thread_output);
        }
        thread_output = (char *)malloc(strlen(temp)+1);
        strcpy(thread_output,temp);

        barcode_type = zbar_get_symbol_name(typ);

        fprintf(stdout, "decoded %s symbol \"%s\"", barcode_type, thread_output);

        //emit imageAnalysed(QString(zbar_get_symbol_name(typ)), QString((char*)(*output)));


        return true;
    }else{
        //zbar_image_destroy(image);
        return false; //BARCODE_TYPE_NONE;
    }

}


