//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef COMMON_H
#define COMMON_H

// avoid API warnings
#define GST_USE_UNSTABLE_API
// Definitions

#define DEVICE_UNKNOWN  -1
#define DEVICE_770  0
#define DEVICE_N800  1
#define DEVICE_N810  2
#define DEVICE_N900  3

#define BARCODE_TYPE_NONE     0
#define BARCODE_TYPE_1D       1
#define BARCODE_TYPE_DMTX     2
#define BARCODE_TYPE_QRCODE   3
#define BARCODE_TYPE_PDF417   4

#define WIDTH  320
#define HEIGHT  240

#define N900_WIDTH  640
#define N900_HEIGHT  480

#define NO_OF_COLUMNS   4

#define SCAN_HISTORY_LENGTH 10

#define TYPE_DMTX "dmtx"

#endif // COMMON_H
