//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef VIDEOWIDGET_H
#define VIDEOWIDGET_H
// qt includes
#include <QWidget>
// gstreamer includes
#include <gst/gst.h>
#include <gst/gstbin.h>
#include <gst/interfaces/xoverlay.h>
#include <gst/interfaces/photography.h>
// other includes
#include <stdio.h>
#include <zbar.h>
// local includes
#include "common.h"

class BarcodeDetector;
class DBusConnection;
using namespace zbar;

class VideoWidget : public QWidget
{
    Q_OBJECT
public:
    VideoWidget(QWidget *parent);
    VideoWidget(QWidget *parent, BarcodeDetector *decoder);
    ~VideoWidget();
    void setData(GstElement *data);
    void refocus();
    void start();
    void stop();
    bool isFocusing();
signals:
    void focusingValueChanged(bool enabled);
private:
    void setFocusing(bool enabled);
    GstElement *data, *pipeline;
    void paintEvent(QPaintEvent *);
    GstBusSyncReply handleCreateWindow(GstBus * bus, GstMessage * message, GstPipeline * pipeline);
    static GstBusSyncReply handleCreateWindow_callback(GstBus * bus, GstMessage * message, GstPipeline * pipeline);
    gboolean busCallback (GstBus * bus, GstMessage * message);
    static gboolean busCallback_callback (GstBus * bus, GstMessage * message);
    gboolean bufferProbeCallback (GstElement *image_sink, GstBuffer *buffer, GstPad *pad);
    static gboolean bufferProbeCallback_callback (GstElement *image_sink, GstBuffer *buffer, GstPad *pad);
    void destroyPipeline();
    bool initPipeline();
    void getDeviceType();
    bool pipelineReady;
    BarcodeDetector *decoder;
    // added from appdata.h
    GstElement *camera_src;
    gboolean isportrait;
    gboolean accelerometers;
    DBusConnection *con;
    guint buffer_cb_id;
    guint timer_id;
    long long last_upc_value;
    int scan_in_progress;
    gchar current_data_table_name[255];
    int deviceType;
    int frame_width;
    int frame_height;
    zbar_image_scanner_t *scanner;
    zbar_image_t *image;
    bool focusing;
};

#endif // VIDEOWIDGET_H
