//Maemo Barcode Reader and Interpreter (mbarcode or maemo-barcode)
//Copyright (C) 2010 Simon Pickering
//Copyright (C) 2010 Svenn-Arne Dragly
//
//Some source code obtained from other individuals/companies (not affiliated with the project), such as
//Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
//
//Various parts of barcode recognition and GStreamer manipulation code written by:
//      Timothy Terriberry
//      Adam Harwell
//      Jonas Hurrelmann
//
//Original GStreamer code based on the maemo-examples package:
//Copyright (C) 2007-2008 Nokia Corporation. All rights reserved.
//Copyright (C) 2006 INdT.
//@author Talita Menezes <talita.menezes@indt.org.br>
//@author Cidorvan Leite <cidorvan.leite@indt.org.br>
//@author Jami Pekkanen <jami.pekkanen@nokia.com>
//
//This program is free software: you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation, either version 3 of the License, or
//(at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program.  If not, see <http://www.gnu.org/licenses/>.

// qt includes
#include <QSet>
#include <QtGui>
// local includes
#include "resultswindow.h"
#include "ui_resultswindow.h"
#include "sinkplugin.h"
#include "plugininterfaces.h"
#include "pluginintermediate.h"

ResultsWindow::ResultsWindow(QWidget *parent) :
    QMainWindow(parent),
    m_ui(new Ui::ResultsWindow)
{
    m_ui->setupUi(this);
    checkTimer = new QTimer(this);
    connect(checkTimer, SIGNAL(timeout()),this,SLOT(checkPlugins()));
}

ResultsWindow::~ResultsWindow()
{
    delete m_ui;
}

void ResultsWindow::setSinkPlugins(QSet<SinkPlugin *>plugins) {
    this->plugins = plugins;
}
void ResultsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void ResultsWindow::processBarcode(QString barcode) {
    m_ui->lblResults->setText("Results for '" + barcode + "'");
    // let's empty the results container!
    int numberOfWidgets = m_ui->resultsContainer->count();
    for(int i = 0; i<numberOfWidgets;i++) { // iterate through all widgets
        QLayoutItem *item = m_ui->resultsContainer->itemAt(0);
        if(item->widget()) { // check if the widget exists, this avoids a segfault in case we have done something stupid
            delete item->widget(); // delete the widget completely
        }
    }
    addedPlugins.clear();
    checkTimer->start(500); // check for updated plugins every x milliseconds
}
void ResultsWindow::checkPlugins() {
    //qDebug("Checking sink plugins...");
    QSetIterator<SinkPlugin*> i(plugins);
    while(i.hasNext()){
        SinkPlugin* sink = i.next();
        //qDebug(qPrintable("Checking sink plugin " + sink->getName()));
        if(sink->isReady() && !addedPlugins.values().contains(sink)) { // check if it's ready and that it has not yet been added
            //qDebug(qPrintable("Adding sink plugin " + sink->getName()));
            // This is an ugly way of finding out which plugin is to be launched when a button is clicked.
            // Maybe this could be solved with a tableView/model?
            PluginIntermediate *pluginIntermediate = new PluginIntermediate(sink, this);
            QPushButton *button = new QPushButton(sink->getText(), this);
            m_ui->resultsContainer->addWidget(button); // just a test function to write some text on screen from plugins
            connect(button,SIGNAL(clicked()),
                    pluginIntermediate,SLOT(clickedPlugin()));
            addedPlugins.insert(sink); // add it to the list of added plugins, so we don't add it twice
        }
    }
}
