#include "pluginsettings.h"
#include "ui_pluginsettings.h"

#include "plugininterfaces.h"

PluginSettings::PluginSettings(QSet<PluginInterface *>pluginInterfaces, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::PluginSettings)
{
    ui->setupUi(this);
    model = new QStandardItemModel(this);
    ui->tblPlugins->setModel(model);
    int pluginId = 0;
    foreach(PluginInterface *interface, pluginInterfaces) {
        QStandardItem *item = new QStandardItem(interface->getName());
        QVariantHash data;
        data.insert("pluginId", pluginId);
        idToInterface.insert(pluginId, interface);
        item->setData(data);
        model->appendRow(item);
        pluginId++;
    }
    ui->tblPlugins->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    ui->tblPlugins->resizeRowsToContents();
}

PluginSettings::~PluginSettings()
{
    delete ui;
}

void PluginSettings::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void PluginSettings::on_tblPlugins_clicked(QModelIndex index)
{
    QStandardItem *item = model->itemFromIndex(index);
    QVariantHash data = item->data().toHash();
    int pluginId = data.value("pluginId").toInt();
    PluginInterface* plugin = idToInterface[pluginId];
    if(plugin->hasSettingsWindow()) {
        plugin->getSettingsWindow(this)->show();
    } else {
        QMessageBox *msgBox = new QMessageBox(QMessageBox::Information, "No settings", "This plugin has no settings window.");
        msgBox->exec();
    }
}
