#ifndef DMTXDECODERTHREAD_H
#define DMTXDECODERTHREAD_H

#include <QObject>
#include <QThread>
#include <QWaitCondition>
#include <qmutex.h>

class DMTXDecoderThread : public QThread
{
public:
    DMTXDecoderThread();
    ~DMTXDecoderThread();
    void run();
    char *thread_buffer;
    char *thread_output;
    int frame_width;
    int frame_height;
    int frame_fourcc;
    bool isDecoding; // so the caller can see if we are running without blocking
    QMutex wait_mutex; // to allow the caller to block the thread when data is not available
    QWaitCondition thread_run; // as above
    bool hasFoundBarcode; // variable set if the decoder found something

private:
    int libdmtx_analyse_image();
    bool doQuit; // to signal the thread to quit
};

#endif // DMTXDECODERTHREAD_H
