#include <Python.h>

#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include <mbarcode-qt/maemobarcodewindow.h>

#include "pythonqtwrapperplugin.h"
#include "pythonqtwrappersink.h"

#include <QString>

static void doDecRef(PyObject* object)
{
    Py_DECREF(object);
}

typedef QSharedPointer<PyObject> pyptr;

pyptr py(PyObject* object)
{
    return pyptr(object, doDecRef);
}

// initialisation, including setting up the slot hooks between this class and the sink itself
void PythonQTWrapperPlugin::initInterface(QWidget *parent) {

    // this is where we find the Python plugins and ask them what types of barcodes they want.
    // we generate one sink per file, adding into each of the sink classes the appropriate name information
    // as well as the barcode types each wants, and any match !match information they tell us about

    // should this is hardcoded...?
    QDir d("/usr/share/mbarcode/plugins/pythonqt/");
    QStringList filter;
    filter << "*.py";
    QStringList list = d.entryList(filter);


    // we need to init the PythonQt business, but if there are no Python plugins installed, we shoudn't bother as it wastes time and memory
    if (list.size()>0){
        qDebug() << "Python plugins found, about to initialise Python runtime.";
        this->initialised=true;
        Py_Initialize();
    }else{
        qDebug() << "No Python plugins found, returning...";
        return; //and make sure we don't get called again
    }

    qDebug() << "PythonQTWrapperPlugin::initInterface() found " << list.size() << " possible plugins.";


    // append our plugin path to the Python path
    PyObject* sysPath = PySys_GetObject("path");
    if ( sysPath )
    {
        QByteArray currentPath = d.absolutePath().toUtf8();
        PyObject* path = PyString_FromString(currentPath.constData());
        PyList_Append(sysPath, path);
    }


    for(int i=0; i<list.size(); ++i)
    {
        QFileInfo f(list.at(i));

        // Create the script name
        PyObject* scriptName = PyString_FromString( QString("%1").arg(f.baseName()).toUtf8().constData() );

        // Load the script
        pyptr script = py(PyImport_Import(scriptName));
        Py_DECREF(scriptName);

        if ( !script ){
            if ( PyErr_Occurred() )
                PyErr_Print();
            continue;
        }

        // Get the entry function
        pyptr entryFunction = py(PyObject_GetAttrString(script.data(), "mbarcode_plugin_instance"));
        if ( !(entryFunction && PyCallable_Check(entryFunction.data())) ){
            if ( PyErr_Occurred() )
                PyErr_Print();

            continue;
        }



        pyptr args = py(PyTuple_New(0));
        PyObject* sinkInstance = PyObject_CallObject(entryFunction.data(), args.data());
        if ( sinkInstance ){
            PythonQTWrapperSink *s = new PythonQTWrapperSink(this, sinkInstance);
            sinks.append(s);
            // I guess we'll need to do this for each sink too.
            connect(parent, SIGNAL(barcodeAnalysedSignal(QString,QString)),
                    s, SLOT(barcodeAnalysed(QString,QString)));
        }else
            continue;

    }

    qDebug() << "PythonQTWrapperPlugin::initInterface() successfully parsed " << sinks.size() << " plugins.";

}

PythonQTWrapperPlugin::~PythonQTWrapperPlugin(){
    if(this->initialised==true)
        Py_Finalize();
}

QSet<PluginAction*> PythonQTWrapperPlugin::getPluginActions() {
    QSet<PluginAction*> newList;

    // iterate through our sinks
    // insert them all into the list
    foreach(PythonQTWrapperSink *s, sinks)
    {
        qDebug() << "PythonQTWrapperPlugin::getPluginActions() inserting sink " << s->getName();
        newList.insert(s);
    }
    return newList;

    //    QSet<PluginAction*> newList = sinks.toSet(); // instead?
}


QString PythonQTWrapperPlugin::getName()
{
    return "PythonQt wrapper plugin";
};

//QMainWindow* PythonQTWrapperPlugin::getSettingsWindow(QWidget *parent) {
//    return new SettingsWindow(parent, this);
//}

Q_EXPORT_PLUGIN2(mbqt_pythonqtwrapperplugin, PythonQTWrapperPlugin)
