#include <PythonQt.h>
#include <QtGui>
#include <QCoreApplication>

int main (int argc, char* argv[]) {
    QApplication app(argc, argv);
    PythonQt::init();
    PythonQtObjectPtr mainModule = PythonQt::self()->getMainModule();
    if(mainModule.isNull()){
        qDebug() << "mainModule is null";
        return -1;
    }
    mainModule.evalScript(QString("import sys\n"));

    {
      // evaluate a python file embedded in executable as resource:
      mainModule.evalFile(QCoreApplication::applicationDirPath () + "/eyed3tagger.py");
      qDebug() << "Doing evalFile(" << QCoreApplication::applicationDirPath() + QString("/eyed3tagger.py") << ")";

      // create an object, hold onto its reference
      PythonQtObjectPtr tag = mainModule.evalScript("EyeD3Tagger()\n", Py_eval_input);
      if(tag.isNull()){
          qDebug() << "Tag is null";
          return -1;

      }

      tag.call("setFileName", QVariantList() << "t.mp3");
      QVariant fn = tag.call("fileName", QVariantList());
      qDebug() << "Output: " << fn.toString();
      // tag goes out of scope, reference count decremented.
    }


    qDebug() << "finished";
    return 0;
}
