#include "plugin.h"
#include "getopinionsink.h"
#include "giveopinionsink.h"
#include "authenticationwindow.h"
#include "settingswindow.h"
#include <mbarcode-qt/plugininterfaces.h>
#include <mbarcode-qt/pluginaction.h>
#include <mbarcode-qt/maemobarcodewindow.h>
#include <QtGui>

void Plugin::initInterface(QWidget *parent)
{
    settings = new QSettings("mbarcode","ii-plugin",this);
    consumerKey = "b9wa8eFawRe7e5uXuh";
    consumerSecret = "dECraCRuphAjAxuHEhePr9BajAFet3BR";
    baseUrl = "http://prosjekter.fribit.no:8080/api/";
    authenticated = false;

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            SLOT(replyFinished(QNetworkReply*)));

    getOpinionSink = new GetOpinionSink(this);
    giveOpinionSink = new GiveOpinionSink(this);
    getOpinionSink->setPlugin(this);
    giveOpinionSink->setPlugin(this);
    connect(parent, SIGNAL(barcodeAnalysedSignal(QString,QString)),
            this, SLOT(barcodeAnalysed(QString,QString)));
}
QSet<PluginAction*> Plugin::getPluginActions() {
    QSet<PluginAction*> newList;
    newList.insert(getOpinionSink);
    newList.insert(giveOpinionSink);
    return newList;
}

void Plugin::barcodeAnalysed(QString barcodeType, QString barcodeData) {
    this->barcodeData = barcodeData;
    this->barcodeType = barcodeType;
}
QString Plugin::getTimestamp() {
    uint time = QDateTime::currentDateTime().toTime_t();
    return QString::number( time );
}
void Plugin::checkAuthentication(QWidget *nextWidget, NextAction nextAction) {
    this->nextWidget = nextWidget;
    this->nextAction = nextAction;
    QString dataUrl = baseUrl + "account/is_authenticated.xml?"; //
    QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + generateOAuthData()));
    manager->get(request);
}
void Plugin::replyFinished(QNetworkReply* reply) {
    qDebug() << "-- Returned data in Plugin::replyFinished --";
    QString data = QString::fromUtf8(reply->readAll()); // use UTF-8 encoding (why doesn't Qt detect this by itself?)
    qDebug() << data;
    if(reply->error() == QNetworkReply::NoError) {
        authenticated = true;
        if(nextAction == GetOpinion) {
            getOpinionSink->clickAction(nextWidget);
        } else if(nextAction == GiveOpinion) {
            giveOpinionSink->clickAction(nextWidget);
        }
    } else {
        authenticated = false;
        AuthenticationWindow *authWin = new AuthenticationWindow(nextWidget, this);
        authWin->show();
    }
}
QString Plugin::generateOAuthData() {
    QTime time = QTime::currentTime();
    QString data = "oauth_version=1.0&oauth_nonce=" + time.toString() + QString::number(time.msec()) + "&oauth_timestamp=" + getTimestamp() +
                  "&oauth_consumer_key=" + consumerKey +
                  "&oauth_token=" + settings->value("accessToken","not-defined").toString() +
                  "&oauth_signature_method=PLAINTEXT&oauth_signature=" + consumerSecret + "%26" + settings->value("accessTokenSecret","not-defined").toString();
    return data;
}
QMainWindow* Plugin::getSettingsWindow(QWidget *parent) {
    return new SettingsWindow(parent, this);
}

Q_EXPORT_PLUGIN2(mbqt_iiplugin, Plugin)
