#include "opinionswindow.h"
#include "ui_opinionswindow.h"
#include "plugin.h"
#include "giveopinionwindow.h"
#include "htmldelegate.h"
#include <QtXml>

OpinionsWindow::OpinionsWindow(QWidget *parent, Plugin *plugin) :
    QMainWindow(parent),
    ui(new Ui::OpinionsWindow)
{
    this->plugin = plugin;
    ui->setupUi(this);

    manager = new QNetworkAccessManager(this);
    connect(manager, SIGNAL(finished(QNetworkReply*)),
            this, SLOT(replyFinished(QNetworkReply*)));
    model = new QStandardItemModel(this);

    ui->tblOpinions->setProperty("FingerScrollable", true);
    ui->tblOpinions->setModel(model);
    ui->tblOpinions->horizontalHeader()->setResizeMode(QHeaderView::Stretch);
    HtmlDelegate *delegate = new HtmlDelegate();
    ui->tblOpinions->setItemDelegateForColumn(0,delegate);

    refreshList();
    setAttribute(Qt::WA_Maemo5StackedWindow);
    
    
}

OpinionsWindow::~OpinionsWindow()
{
    delete ui;
}

void OpinionsWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void OpinionsWindow::refreshList() {
    //Getting data
    QString dataUrl = plugin->baseUrl + "opinion/show.xml";
    QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "?" + plugin->generateOAuthData()));
    requestType = GetOpinions;
    manager->get(request);
}

void OpinionsWindow::replyFinished(QNetworkReply* reply) {
    QString data = QString::fromUtf8(reply->readAll()); // use UTF-8 encoding (why doesn't Qt detect this by itself?)
    qDebug() << "\n\n----Returned data---\n\n" << data << "\n\n\n";
    if(reply->error() == QNetworkReply::NoError) {
        if(requestType==GetOpinions) {
            QDomDocument doc;
            doc.setContent(data);
            QDomElement response = doc.documentElement();
            if(response.isNull()) {
                qDebug("No response found!");
            }
            QDomElement nodes = response.firstChildElement("opinions");
            if(nodes.isNull()) {
                qDebug("No opinions found!");
            }
            QDomElement resource = nodes.firstChildElement("resource");
            int row = 0;
            while(!resource.isNull()) {
                QDomElement id = resource.firstChildElement("id");
                QDomElement score = resource.firstChildElement("score");
                QDomElement description = resource.firstChildElement("description");
                QDomElement identifier = resource.firstChildElement("identifier");
                QDomElement identifierType = identifier.firstChildElement("type");
                QDomElement identifierData = identifier.firstChildElement("data");

                int convertedScore = (int)(score.text().toDouble() * 100.0);

                QStandardItem *idTypeItem = new QStandardItem(identifierType.text() + ": " +
                                                              identifierData.text() +
                                                              "<br/><span style='font-size: small; color:grey'>" +
                                                              description.text() + "<br/>" +
                                                              "Score: " + QString::number(convertedScore) +
                                                              "</span>");
                QStandardItem *removeItem = new QStandardItem(QIcon(":/icons/usertrash.png"),"Remove");

                QVariantHash itemData;
                itemData.insert("id", id.text());
                itemData.insert("identifierType", identifierType.text());
                itemData.insert("identifierData", identifierData.text());
                itemData.insert("score", convertedScore);
                itemData.insert("description", description.text());

                idTypeItem->setData(itemData);
                removeItem->setData(itemData);

                removeItem->setTextAlignment(Qt::AlignRight);

                model->setItem(row,0,idTypeItem);
                model->setItem(row,1,removeItem);

                resource = resource.nextSiblingElement("resource");
                row++;
            }
        //    ui->tblOpinions->resizeColumnsToContents();
            ui->tblOpinions->resizeRowsToContents();
        } else if(requestType==DeleteOpinion) {
            refreshList();
        }
    } else if(reply->error() == QNetworkReply::ContentNotFoundError) {
        QMessageBox msgBox(QMessageBox::Information, "Not found", "The opinion does not exist anymore.");
        msgBox.exec();
    } else {
        QMessageBox msgBox(QMessageBox::Critical, "Error", "An error occured, but we have no idea why. Please check the application logs and report the mighty developers.");
        msgBox.exec();
    }
}

void OpinionsWindow::on_tblOpinions_clicked(QModelIndex index)
{
    QStandardItem *item = model->itemFromIndex(index);
    QVariantHash data = item->data().toHash();
    if(index.column() == 0) {
        GiveOpinionWindow *win = new GiveOpinionWindow(this, this->plugin, GiveOpinionWindow::UpdateOpinion);
        win->setScore(data.value("score").toInt());
        win->setDescription(data.value("description").toString());
        win->setOpinionId(data.value("id").toString());
        win->show();
    } else if(index.column() == 1) {
        QMessageBox *prompt = new QMessageBox(this);
        prompt->setWindowTitle("Remove opinion?");
        prompt->setText("Are you really sure you want to remove this opinion?");
        prompt->setStandardButtons(QMessageBox::Ok | QMessageBox::Cancel);
        int ret = prompt->exec();
        if(ret == QMessageBox::Ok) {
            QString dataUrl = plugin->baseUrl + "opinion/remove/" + data.value("id").toString() + ".xml"; //
            QNetworkRequest request = QNetworkRequest(QUrl(dataUrl + "?" + plugin->generateOAuthData()));
            requestType = DeleteOpinion;
            request.setRawHeader("X-HTTP-Method-Override","DELETE");
            manager->post(request,"");
        }
    }
    ui->tblOpinions->clearSelection(); // mimic the behaviour of Hildon tables (like in the e-mail app)
}
