# maxCPU
# Version 0.1.8-0 English version
# Home Desktop Widget for quickly changin of CPU's clock
# by Marco (m750 at www.maemomeego.net)

import hildon
import hildondesktop
import os
import sys
import gtk
import gobject

import dbus
from dbus.mainloop.glib import DBusGMainLoop

# definisco Label e bottoni a livello globale (inserendoli qui)

testo = gtk.Label(" Titan ")
testo.set_width_chars(8)
button_1 = gtk.Button("+")
button_2 = gtk.Button("-")

# variabile globale
# la dichiarazione va ripetuta nei def
global risultato
global conferma_ok
conferma_ok = 0

def no_kernel_config():
    dialog = gtk.Dialog()
    dialog.set_title('Package "kernel-power-settings" not found!')
    dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
    ris = dialog.run()
    dialog.destroy()


def getmaxfreq():
        if not os.path.exists('/usr/sbin/kernel-config'):
        	no_kernel_config()

        try:
             maxcpu = os.popen('echo $((`cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq`/1000))').read()
        except:
             print (maxcpu)
        else:
             maxcpu = maxcpu.strip()
             #print maxcpu, "MHz"
             return(maxcpu)


def getminfreq():
        mincpu = os.popen('echo $((`cat /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq`/1000))').read()
        mincpu = mincpu.strip()
        return(mincpu)


# aggiorno la label con la frequenza massima e cambio il colore
def scrivi_frequenza():
    mhz = int(getmaxfreq())
    scrivi = "<span foreground='Red'> Titan </span>"
    if mhz > 600:
           scrivi = "<span foreground='Red'> " + str(mhz) + " MHz </span>"
    else:
          scrivi = "<span foreground='White'> " + str(mhz) + " MHz </span>"
    testo.set_markup( scrivi )


#--------
# verifica unlock per aggiornamento label
# tmo reference

def ts_kb_locked(mode):
    if mode == "unlocked":
	scrivi_frequenza()


DBusGMainLoop(set_as_default=True)
sys_bus = dbus.SystemBus()

#get initial states
mce_proxy_request = sys_bus.get_object('com.nokia.mce', '/com/nokia/mce/request')
mce_request_iface = dbus.Interface(mce_proxy_request, dbus_interface='com.nokia.mce.request')
ts_kb_locked(mce_request_iface.get_tklock_mode())

#watch for changes
sys_bus.add_signal_receiver(ts_kb_locked, path='/com/nokia/mce/signal', dbus_interface='com.nokia.mce.signal', signal_name='tklock_mode_ind')
#--------

def conferma():
    dialog = gtk.Dialog()
    testo = "Do you really want to overclock?"

    dialog.set_title(testo)
    capt=gtk.Label()
    capt.set_label("This question will not repeat until\nthe next reboot-power off/on)")
    dialog.vbox.add(capt)

    dialog.add_button(gtk.STOCK_YES, gtk.RESPONSE_YES)
    dialog.add_button(gtk.STOCK_NO, gtk.RESPONSE_NO)

    dialog.show_all()
    global risultato
    risultato = dialog.run()
    dialog.destroy()


#def limite_min_max():
    #dialog = gtk.Dialog()
    #dialog.set_title('maxCPU: CPU limit')
    #dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
    #ris = dialog.run()
    #dialog.destroy()
  

def aumenta(self, data=None):
    global conferma_ok
    #print "Aumento?"
    mhz = int(getmaxfreq())
    fmin = int(getminfreq())


    if mhz == 250:
        frequenza_nuova = 500
    elif mhz == 500:
        frequenza_nuova = 550
    elif mhz == 550:
        frequenza_nuova = 600
    elif mhz == 600:
        frequenza_nuova = 700
    elif mhz == 700:
        frequenza_nuova = 750
    elif mhz == 750:
        frequenza_nuova = 805
    elif mhz == 805:
        frequenza_nuova = 850
    elif mhz == 850:
        frequenza_nuova = 900
    elif mhz == 900:
        frequenza_nuova = 950
    elif mhz == 950:
        frequenza_nuova = 1000
    elif mhz == 1000:
        frequenza_nuova = 1100
    elif mhz == 1100:
        frequenza_nuova = 1150
    else:
        frequenza_nuova = mhz
        #limite_min_max()
        banner = hildon.hildon_banner_show_information(self, '', "maxCPU: CPU limit!")
        banner.set_timeout(1500)



    if frequenza_nuova > mhz and (frequenza_nuova == 700 and conferma_ok == 0) :
        conferma()
        global risultato 
        if risultato == gtk.RESPONSE_YES:
            conferma_ok = 1 
            os.popen("/usr/sbin/kernel-config limits " + str(fmin) + " " + str(frequenza_nuova))
            print "kernel-config limits " + str(fmin) + " " + str(frequenza_nuova)

    elif frequenza_nuova > mhz:
        print "kernel-config limits " + str(fmin) + " " + str(frequenza_nuova)
        os.popen("/usr/sbin/kernel-config limits " + str(fmin) + " " + str(frequenza_nuova))
    else:
        print "annulla"

    scrivi_frequenza()


def diminuisci(self, data=None):
    #print "Diminuisco"
    mhz = int(getmaxfreq())
    fmin = int(getminfreq())
    #print fmin, " ", mhz

    if mhz == fmin:
        banner = hildon.hildon_banner_show_information(self, '', "maxCPU: fmin = fmax")
        banner.set_timeout(1500)
        return

    if mhz == 500:
        frequenza_nuova = 250
    elif mhz == 550:
        frequenza_nuova = 500
    elif mhz == 600:
        frequenza_nuova = 550
    elif mhz == 700:
        frequenza_nuova = 600
    elif mhz == 750:
        frequenza_nuova = 700
    elif mhz == 805:
        frequenza_nuova = 750
    elif mhz == 850:
        frequenza_nuova = 805
    elif mhz == 900:
        frequenza_nuova = 850
    elif mhz == 950:
        frequenza_nuova = 900
    elif mhz == 1000:
        frequenza_nuova = 950
    elif mhz == 1100:
        frequenza_nuova = 1000
    elif mhz == 1150:
        frequenza_nuova = 1100
    else:
        frequenza_nuova = mhz
        #limite_min_max()
        banner = hildon.hildon_banner_show_information(self, '', "maxCPU: CPU limit!")
        banner.set_timeout(1500)

    if frequenza_nuova < mhz and frequenza_nuova >= fmin:

        print "kernel-config limits " + str(fmin) + " " + str(frequenza_nuova)
        os.popen("/usr/sbin/kernel-config limits " + str(fmin) + " " + str(frequenza_nuova))

    scrivi_frequenza()


class maxCPU(hildondesktop.HomePluginItem):

    def __init__(self):
        hildondesktop.HomePluginItem.__init__(self)

        # dichiarazione esitenza finestra dei settaggi
        self.set_settings(True)
        self.connect('show-settings', self.on_settings)
       
        # modifica bottoni
        button_1.set_size_request(50, 46)
        button_2.set_size_request(50, 46)

        # dichiarazione box
        box1 = gtk.HBox()
        box1.set_border_width(2)

        # aggiunta box e resto
        self.add(box1)
        box1.add(button_2)
        box1.add(testo)
        box1.add(button_1)

        # mostra il box
        box1.show_all()

        scrivi_frequenza()

        button_1.connect("clicked", aumenta)
        button_2.connect("clicked", diminuisci)

# dichiarazione finestra settaggi
    def on_settings(self, widget):

        # dialog crea una finestra in basso con dei messaggi
        dialog = gtk.Dialog()
        dialog.set_title('maxCPU')
        dialog.vbox.add(gtk.Label("Quickly changin of CPU's clock"))
        dialog.vbox.add(gtk.Label('Version 0.1.8 EN (2011-02-10)'))
        dialog.vbox.add(gtk.Label('250 Mhz<= Fmin <= newClock <= 1150 Mhz'))
        dialog.vbox.add(gtk.Label('Changes do not remain after reboot'))
        dialog.vbox.add(gtk.Label('Work only with Power Kernel, packages:'))
        dialog.vbox.add(gtk.Label('"enhanced linux kernel for power user" and'))
        dialog.vbox.add(gtk.Label('"enhanced linux kernel for power user(settings)"'))
        label = gtk.Label()
        label.set_markup("<span foreground='Red'>WARNING</span>")
        dialog.vbox.add(label)
        dialog.vbox.add(gtk.Label('overclocking voids your warranty and may damage your device'))
        dialog.vbox.add(gtk.Label(' '))
        label = gtk.Label()
        label.set_markup("<small>by Marco (m750 at www.maemomeego.net)</small>");
        dialog.vbox.add(label)
        dialog.show_all()
        result = dialog.run()
        dialog.destroy()

hd_plugin_type = maxCPU
# per avviarlo da shell
if __name__ == '__main__':
    gobject.type_register(hd_plugin_type)
    obj = gobject.new(hd_plugin_type, plugin_id=hd_plugin_type.__class__.__name__)
    obj.show_all()
    gtk.main()
