#ifndef FORMULA_H
#define FORMULA_H

/*
  MathJinni - A simple formular calculator
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Object.h>

#include <Lum/Model/Action.h>
#include <Lum/Model/String.h>
#include <Lum/Model/Selection.h>
#include <Lum/Model/Table.h>
#include <Lum/Model/Tree.h>

#include <Lum/Table.h>

#include "Configuration.h"

typedef Lum::Model::StdTable<Formula*>     FormulaModel;
typedef Lum::Base::Reference<FormulaModel> FormulaModelRef;

class FormulaCalc : public Lum::Component, public ConfigPlugin
{
private:
  Lum::Model::ActionRef              selectAction;
  Lum::Model::ActionRef              executeAction;
  Lum::Model::SizeTRef               category;
  Lum::Model::SizeTRef               subCategory;
  Lum::Model::StringTableRef         categories;
  Lum::Model::StringTableRef         subCategories;
  FormulaModelRef                    functions;
  Lum::Model::SingleLineSelectionRef function;

public:
  FormulaCalc();

  void CalcSize();

  void Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg);

  void LoadConfig(Lum::Config::Node *top);
  void StoreConfig(Lum::Config::Node *top);
};

#endif
