 #!/usr/bin/env python

import pygtk
pygtk.require("2.0")
import gtk
import urllib2
import HTMLParser
import hildon
import ConfigParser

from portrait import FremantleRotation

#main_window = mainWindow # your main hildon.StackableWindow
app_name = 'NameOfYourApp' # the name of your app
app_version = '1.0' # the version number of your app
initial_mode = FremantleRotation.AUTOMATIC

class LigneHoraire(object):
    def __init__(self, code_mission, heure_de_passage):
        self.code_mission = code_mission
        self.heure_de_passage = heure_de_passage
    
    def add_to_treestore(self, treestore):
        print treestore
        treestore.append(None, [self.code_mission, self.heure_de_passage])
    
    

class tableParser(HTMLParser.HTMLParser):
    def __init__(self):
        HTMLParser.HTMLParser.__init__(self)
        self.table_horaires3 = False
        self.code_de_mission = False
        self.a_code_de_mission = False
        self.heure_de_passage = False
        self.liste_train = []
        self.liste_horaire = []
        self.list_ligne_horaire = []
        
    def handle_starttag(self, tag, attrs):
        if (tag == 'table' and (dict(attrs)['class'] == 'horaires3')):
            self.table_horaires3 = True
        
        elif self.table_horaires3 and tag == 'td':
            try:
                self.code_de_mission = (
                    dict(attrs)['headers'] == 'Code_de_mission')
                self.heure_de_passage = (
                    dict(attrs)['headers'] == 'Heure_de_passage')
            except KeyError:
                if dict(attrs).has_key('headers'):
                    raise
                else:
                    pass
        else:
            self.a_code_de_mission = (tag == 'a' and self.code_de_mission)
        
    def handle_data(self, data):
        if self.a_code_de_mission:
            self.liste_train.append(data.strip())
        if self.heure_de_passage:
            self.liste_horaire.append(data.strip())
            
    def handle_endtag(self,tag):
        self.a_code_de_mission ^= (self.a_code_de_mission and tag == 'a')
        self.heure_de_passage ^= (self.heure_de_passage and tag == 'td')
    
    def get_list_ligne_horaire(self):
        print 'get_list_ligne_horaire'
        z = 0
        print self.liste_train
        for i in self.liste_train:
            self.list_ligne_horaire.append(LigneHoraire(code_mission=i, heure_de_passage=self.liste_horaire[z]))
            z += 1
        return self.list_ligne_horaire
    
    

class Trajet(object):
    def __init__(self, gare_source, gare_dest):
        self.gare_source = gare_source
        self.gare_dest = gare_dest
        self.parse() 
    def get_liste_train(self):
        return self.p.liste_train 
    def get_liste_horaire(self): 
        return self.p.liste_horaire
    def parse(self):
        self.p = tableParser()
        #print "URL:" 
        #print 'http://www.transilien.com/web/ITProchainsTrainsAvecDest.do?codeTr3aDepart='+self.gare_source.shortname+'&codeTr3aDest='+self.gare_dest.shortname+'&urlModule=/site/pid/184&gareAcc=true'
        rsrc = urllib2.urlopen('http://www.transilien.com/web/ITProchainsTrainsAvecDest.do?codeTr3aDepart='+self.gare_source.shortname+'&codeTr3aDest='+self.gare_dest.shortname+'&urlModule=/site/pid/184&gareAcc=true')
        self.p.feed(rsrc.read())
        print "parsing ok"
        
    def refresh_treestore(self, treestore):
        print 'refresh'
        print treestore
        
        treestore.clear()
        liste_ligne_horaire = self.p.get_list_ligne_horaire()
        print liste_ligne_horaire
        for i in liste_ligne_horaire:
            print i
            i.add_to_treestore(treestore)

class ConfFile(object):
    def __init__(self, fichier):
        self.c = ConfigParser.ConfigParser()
        self.c.read(fichier)
    def get_short_name(self, longname):
        return self.c.get('ListeDesGares', longname)
    def get_liste_des_gares(self):
        return self.c.items('ListeDesGares') 

class LongNameGare(object):
    def __init__(self, longname):
        self.longname = longname
    def get_gare(self, conffile):
        short_name = conffile.get_short_name(self.longname)
        return Gare(short_name)

class Gare(object):
    def __init__(self, shortname):
        self.shortname = shortname




class TransilienUI:
    def __init__(self):
        mainWindow = hildon.Window()
        mainWindow.set_title("Horaires des Prochains Trains")
        mainWindow.connect("destroy", self.on_mainWindow_destroy)

        rotation_object = FremantleRotation(app_name, mainWindow, app_version, initial_mode)
        refreshButton = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT,
                              hildon.BUTTON_ARRANGEMENT_HORIZONTAL, "Actualiser")
        refreshButton.connect("clicked", self.on_refreshButton_clicked)

        self.treestore = gtk.TreeStore(str, str)
        self.treeview = gtk.TreeView(self.treestore)

        self.tvcolumn_train = gtk.TreeViewColumn('Train', gtk.CellRendererText(), text=0)
        self.treeview.append_column(self.tvcolumn_train)
        
        self.tvcolumn_horaire = gtk.TreeViewColumn('Horaire', gtk.CellRendererText(), text=1)
        self.treeview.append_column(self.tvcolumn_horaire)


        picker_button_source = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,                            hildon.BUTTON_ARRANGEMENT_VERTICAL)
        picker_button_source.set_title("Gare de Depart")
        self.combo_source = hildon.TouchSelectorEntry(text=True)
        self.combo_dest = hildon.TouchSelectorEntry(text=True)

        for i in ConfFile('example.cfg').get_liste_des_gares():
            self.combo_source.append_text(i[0])
            self.combo_dest.append_text(i[0])
        picker_button_source.set_selector(self.combo_source)
        

        picker_button_dest = hildon.PickerButton(gtk.HILDON_SIZE_AUTO,                            hildon.BUTTON_ARRANGEMENT_VERTICAL)
        picker_button_dest.set_title("Gare d'arrivee")
        picker_button_dest.set_selector(self.combo_dest)
        
        vBox = gtk.VBox()
        hBox = gtk.HBox()
        vBox.pack_start(hBox)
        hBox.pack_start(picker_button_source)
        hBox.pack_start(picker_button_dest)
        vBox.pack_start(self.treeview)
        vBox.pack_start(refreshButton)
        

        mainWindow.add(vBox)
        mainWindow.show_all()

    def on_mainWindow_destroy(self, widget):
        gtk.main_quit()

    def on_refreshButton_clicked(self, widget):
        gare_source = LongNameGare(self.combo_source.get_current_text()).get_gare(ConfFile('example.cfg'))
        gare_dest = LongNameGare(self.combo_dest.get_current_text()).get_gare(ConfFile('example.cfg'))
        trajet = Trajet(gare_source , gare_dest)
        print trajet
        print self.treestore
        trajet.refresh_treestore(self.treestore)


if __name__ == "__main__":
    TransilienUI()
    gtk.main()
