#include "marhythm.h"
#include "callbacks.h"

/*
void scrollButtonClick( GtkWidget *button, gpointer data )
{
	MarhythmData *applicationData;
	applicationData = (MarhythmData*) data;
	
	marhythm_scroll_to_selected_date( data );
}

void marhythm_scroll_to_selected_date( MarhythmData *applicationData )
{
	MR_BIORHYTHM_CHART( applicationData->biorhythmUpdatableWidgets.biorhythmChart )
}
*/

void marhythm_show_about_dialog()
{
	GtkWidget *aboutDialog;
	GtkWidget *aboutDialogContentArea;
	GtkWidget *applicationLabel;
	GtkWidget *authorLabel;
	GtkWidget *webLabel;
	
	PangoAttrList *applicationLabelAttributeList;
	PangoAttribute *applicationLabelSizeAttribute;
	
	aboutDialog = gtk_dialog_new_with_buttons("About Marhythm",
					NULL,
					GTK_DIALOG_MODAL,
					GTK_STOCK_CLOSE,
					GTK_RESPONSE_NONE,
					NULL);
					
	aboutDialogContentArea = gtk_dialog_get_content_area( GTK_DIALOG( aboutDialog ) );
	

	
	
	applicationLabelSizeAttribute = pango_attr_size_new( PANGO_SCALE * 30 );	
	applicationLabelAttributeList = pango_attr_list_new();
	pango_attr_list_insert( applicationLabelAttributeList,
							applicationLabelSizeAttribute);

	applicationLabel = gtk_label_new( "Marhythm " PACKAGE_VERSION );
	
	gtk_label_set_attributes( GTK_LABEL( applicationLabel ),
								applicationLabelAttributeList );
	
	gtk_box_pack_start( GTK_BOX( aboutDialogContentArea ),
						applicationLabel,
						FALSE,
						FALSE,
						0);
						
	authorLabel = gtk_label_new("Salvador Cabrera <salvadorcabrera@gmail.com>");
	
	gtk_box_pack_start( GTK_BOX( aboutDialogContentArea ),
						authorLabel,
						FALSE,
						FALSE,
						0);
						
	webLabel = gtk_label_new( "http://txava.org/stuff#marhythm" );
	
	
	gtk_box_pack_start( GTK_BOX( aboutDialogContentArea ),
						webLabel,
						FALSE,
						FALSE,
						0);
	
	gtk_widget_show_all( aboutDialog );
	
	
	
	gtk_box_set_spacing( GTK_BOX( aboutDialogContentArea ),
								10);
	gtk_dialog_run( GTK_DIALOG( aboutDialog ) );
	
	
	
	
	gtk_widget_destroy( aboutDialog );
	
	
	pango_attribute_destroy( applicationLabelSizeAttribute );
	
}

void marhythm_update_biorhythm_widgets( MarhythmBiorhythmUpdatableWidgets *biorhythmUpdatableWidgets, MarhythmBiorhythmValues biorhythmValues, GDate *selectedDate )
{
	gchar selectedDateString[128];
	
	marhythm_update_stars_from_biorhythm_value( biorhythmUpdatableWidgets->physicalStarWidgets,
		biorhythmValues.physical );
	marhythm_update_stars_from_biorhythm_value( biorhythmUpdatableWidgets->emotionalStarWidgets,
		biorhythmValues.emotional );
	marhythm_update_stars_from_biorhythm_value( biorhythmUpdatableWidgets->intellectualStarWidgets,
		biorhythmValues.intellectual );
	
	g_date_strftime( (gchar*) selectedDateString, sizeof( selectedDateString ), "%x", selectedDate );
	
	gtk_label_set_text( biorhythmUpdatableWidgets->selectedDateLabel, selectedDateString );
	
	
	g_object_set( G_OBJECT( biorhythmUpdatableWidgets->biorhythmChart ),
		"highlight-date",
		selectedDate,
		NULL );
}

void marhythm_update_biorhythm_screen( MarhythmData *applicationData )
{
	MarhythmBiorhythmValues biorhythmValues;
	
	biorhythmValues.physical = mr_calculate_cycle_energy_from_date( applicationData->currentContactBirthDate,
								applicationData->currentSelectedDate,
								MR_PHYSIC_CYCLE );
								
	biorhythmValues.emotional = mr_calculate_cycle_energy_from_date( applicationData->currentContactBirthDate,
								applicationData->currentSelectedDate,
								MR_EMOTIONAL_CYCLE );
	
	biorhythmValues.intellectual = mr_calculate_cycle_energy_from_date( applicationData->currentContactBirthDate,
								applicationData->currentSelectedDate,
								MR_INTELLECTUAL_CYCLE );
	
	g_object_set( G_OBJECT( applicationData->biorhythmUpdatableWidgets.biorhythmChart ),
		"reference-date",
		applicationData->currentReferenceDate,
		NULL );
	
	marhythm_update_biorhythm_widgets( &applicationData->biorhythmUpdatableWidgets,
									biorhythmValues,
									applicationData->currentSelectedDate );
}

void marhythm_update_stars_from_biorhythm_value( GtkWidget* widgetsArray[], gfloat value )
{
	gint enabledStars = 0;
	
	if( value < 15.0 && value > -15.0 )
	{
		gtk_image_set_from_file( GTK_IMAGE( widgetsArray[0] ), MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
		gtk_image_set_from_file( GTK_IMAGE( widgetsArray[1] ), MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
		gtk_image_set_from_file( GTK_IMAGE( widgetsArray[2] ), MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
		gtk_image_set_from_file( GTK_IMAGE( widgetsArray[3] ), MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
	}
	else
	{
		if( value >= 85.0  )
		{
			enabledStars = 4;
		}
		
		if( value >= 50.0 && value < 85.0 )
		{
			enabledStars = 3;
		}
		
		if( value >= 15.0 && value < 50.0 )
		{
			enabledStars = 2;
		}
		
		if( value > -50.0 && value <= -15.0 )
		{
			enabledStars = 2;
		}
		
		if( value > -85.0 && value <= -50.0 )
		{
			enabledStars = 1;
		}
		
		if( value <= -85 )
		{
			enabledStars = 0;
		}
		
		int i = 0;
		
		for( i = 0; i < enabledStars; i++  )
		{
			gtk_image_set_from_file( GTK_IMAGE( widgetsArray[i] ), MARHYTHM_IMAGE_STAR_ENABLED_PATH );
		}
		
		
		for( i = enabledStars; i < 4; i++ )
		{
			gtk_image_set_from_file( GTK_IMAGE( widgetsArray[i] ), MARHYTHM_IMAGE_STAR_DISABLED_PATH );
		}
		
	}
}

void marhythm_create_stars_from_biorhythm_value( GtkWidget* widgetsArray[], gfloat value )
{
	gint enabledStars = 0;
	
	if( value < 15.0 && value > -15.0 )
	{
		widgetsArray[0] = gtk_image_new_from_file( MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
		widgetsArray[1] = gtk_image_new_from_file( MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
		widgetsArray[2] = gtk_image_new_from_file( MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
		widgetsArray[3] = gtk_image_new_from_file( MARHYTHM_IMAGE_STAR_CRITICAL_PATH );
	}
	else
	{
		if( value >= 85.0  )
		{
			enabledStars = 4;
		}
		
		if( value >= 50.0 && value < 85.0 )
		{
			enabledStars = 3;
		}
		
		if( value >= 15.0 && value < 50.0 )
		{
			enabledStars = 2;
		}
		
		if( value > -50.0 && value <= -15.0 )
		{
			enabledStars = 2;
		}
		
		if( value > -85.0 && value <= -50.0 )
		{
			enabledStars = 1;
		}
		
		if( value <= -85 )
		{
			enabledStars = 0;
		}
		
		int i = 0;
		
		for( i = 0; i < enabledStars; i++  )
		{
			widgetsArray[i] = gtk_image_new_from_file( MARHYTHM_IMAGE_STAR_ENABLED_PATH );
		}
		
		
		for( i = enabledStars; i < 4; i++ )
		{
			widgetsArray[i] = gtk_image_new_from_file( MARHYTHM_IMAGE_STAR_DISABLED_PATH );
		}
		
	}
}

void
marhythm_display_biorhythm( MarhythmData *applicationData, OssoABookContact *contact )
{
    GtkWidget *personalBiorhythmWindow;

    OssoABookAvatar *avatar;
    
    GtkWidget *mainContainer;
    GtkWidget *topContactData;
    GtkWidget *avatarImage;
    
    GDate *birthDate;    
    EContactDate *contactBirthDate;
    
    gfloat physicalValue;
    gfloat emotionalValue;
    gfloat intellectualValue;
    
    contactBirthDate = ( EContactDate* )  e_contact_get ( E_CONTACT ( contact ),
                                                         E_CONTACT_BIRTH_DATE );

    birthDate = g_date_new_dmy( contactBirthDate->day, contactBirthDate->month , contactBirthDate->year );
    
    applicationData->currentContactBirthDate = birthDate;
    
    physicalValue = mr_calculate_cycle_energy_from_date( birthDate, applicationData->currentReferenceDate, MR_PHYSIC_CYCLE );
    emotionalValue = mr_calculate_cycle_energy_from_date( birthDate, applicationData->currentReferenceDate, MR_EMOTIONAL_CYCLE );
    intellectualValue = mr_calculate_cycle_energy_from_date( birthDate, applicationData->currentReferenceDate, MR_INTELLECTUAL_CYCLE );

    avatar =  osso_abook_contact_get_avatar ( contact ,
                                                         NULL,
                                                         NULL);
    avatarImage = osso_abook_avatar_image_new_with_avatar (avatar,
                                                         OSSO_ABOOK_PIXEL_SIZE_AVATAR_MEDIUM);

    personalBiorhythmWindow = hildon_stackable_window_new();


    gtk_window_set_title ( GTK_WINDOW( personalBiorhythmWindow ) ,
                                    osso_abook_contact_get_display_name( contact  ) );
                               
    GtkWidget *biorhythmWindowMenu;    
    biorhythmWindowMenu = hildon_app_menu_new();
   
    GtkWidget *referenceDateSelectorButton;
    referenceDateSelectorButton = hildon_date_button_new( HILDON_SIZE_AUTO,
                                                            HILDON_BUTTON_ARRANGEMENT_VERTICAL );
    hildon_button_set_title( HILDON_BUTTON( referenceDateSelectorButton ),
							"Reference date");
	g_signal_connect_after( GTK_OBJECT( referenceDateSelectorButton ),
							"value-changed",
							G_CALLBACK( referenceDateChanged ),
							applicationData);

	hildon_window_set_app_menu( HILDON_WINDOW( personalBiorhythmWindow ),
								HILDON_APP_MENU( biorhythmWindowMenu ) );

    
    hildon_app_menu_append( HILDON_APP_MENU( biorhythmWindowMenu ),
								GTK_BUTTON( referenceDateSelectorButton ) );
	gtk_widget_show_all( biorhythmWindowMenu );
    
    

    mainContainer =  gtk_vbox_new( FALSE, HILDON_MARGIN_DEFAULT );

    topContactData = gtk_hbox_new( FALSE, 0 );

    gtk_box_pack_start( GTK_BOX( topContactData ), avatarImage, FALSE, FALSE, HILDON_MARGIN_DEFAULT );


    /* START BIORHYTHM RATE */

    GtkWidget *biorhythmDataTable;

    biorhythmDataTable = gtk_table_new (3,
                                                         5,
                                                         FALSE);

    gtk_widget_set_size_request ( GTK_WIDGET( biorhythmDataTable ),
                                                        -1,
                                                        OSSO_ABOOK_PIXEL_SIZE_AVATAR_MEDIUM);
 
    gtk_box_pack_start ( GTK_BOX( topContactData ),
                                        biorhythmDataTable,
                                        FALSE,
                                        FALSE,
                                        HILDON_MARGIN_DEFAULT );


    GtkWidget *physicalLabel, *emotionalLabel, *intellectualLabel;
    GtkWidget *physicalStar1, *physicalStar2, *physicalStar3, *physicalStar4;
    GtkWidget *emotionalStar1, *emotionalStar2, *emotionalStar3, *emotionalStar4;
    GtkWidget *intellectualStar1, *intellectualStar2, *intellectualStar3, *intellectualStar4;
    
    
    MarhythmBiorhythmUpdatableWidgets *biorhythmUpdatableWidgets = &applicationData->biorhythmUpdatableWidgets;
    
    marhythm_create_stars_from_biorhythm_value( biorhythmUpdatableWidgets->physicalStarWidgets, physicalValue );
    marhythm_create_stars_from_biorhythm_value( biorhythmUpdatableWidgets->emotionalStarWidgets, emotionalValue );
    marhythm_create_stars_from_biorhythm_value( biorhythmUpdatableWidgets->intellectualStarWidgets, intellectualValue );

    physicalLabel = gtk_label_new( "Physical" );
    emotionalLabel = gtk_label_new( "Emotional" );
    intellectualLabel = gtk_label_new( "Intellectual" );

    gtk_misc_set_alignment ( GTK_MISC( physicalLabel ),
                                        0,
                                        0.5 );

    gtk_misc_set_alignment ( GTK_MISC( emotionalLabel ),
                                        0,
                                        0.5 );

    gtk_misc_set_alignment ( GTK_MISC( intellectualLabel ),
                                        0,
                                        0.5 );

	physicalStar1 = biorhythmUpdatableWidgets->physicalStarWidgets[0];
    physicalStar2 = biorhythmUpdatableWidgets->physicalStarWidgets[1];
    physicalStar3 = biorhythmUpdatableWidgets->physicalStarWidgets[2];
    physicalStar4 = biorhythmUpdatableWidgets->physicalStarWidgets[3];

    emotionalStar1 = biorhythmUpdatableWidgets->emotionalStarWidgets[0];
    emotionalStar2 = biorhythmUpdatableWidgets->emotionalStarWidgets[1];
    emotionalStar3 = biorhythmUpdatableWidgets->emotionalStarWidgets[2];
    emotionalStar4 = biorhythmUpdatableWidgets->emotionalStarWidgets[3];

    intellectualStar1 = biorhythmUpdatableWidgets->intellectualStarWidgets[0];
    intellectualStar2 = biorhythmUpdatableWidgets->intellectualStarWidgets[1];
    intellectualStar3 = biorhythmUpdatableWidgets->intellectualStarWidgets[2];
    intellectualStar4 = biorhythmUpdatableWidgets->intellectualStarWidgets[3];

    /* START ATTACHING LABELS */
    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     physicalLabel,
                                     0,
                                     1,
                                     0,
                                     1,
                                     GTK_EXPAND | GTK_FILL,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     emotionalLabel,
                                     0,
                                     1,
                                     1,
                                     2,
                                     GTK_EXPAND | GTK_FILL,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     intellectualLabel,
                                     0,
                                     1,
                                     2,
                                     3,
                                     GTK_EXPAND | GTK_FILL,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    /* END ATTACHING LABELS */

    /* START ATTACHING STARS */

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     physicalStar1,
                                     1,
                                     2,
                                     0,
                                     1,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     physicalStar2,
                                     2,
                                     3,
                                     0,
                                     1,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     physicalStar3,
                                     3,
                                     4,
                                     0,
                                     1,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     physicalStar4,
                                     4,
                                     5,
                                     0,
                                     1,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     HILDON_MARGIN_HALF,
                                     0);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     emotionalStar1,
                                     1,
                                     2,
                                     1,
                                     2,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     emotionalStar2,
                                     2,
                                     3,
                                     1,
                                     2,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     emotionalStar3,
                                     3,
                                     4,
                                     1,
                                     2,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     emotionalStar4,
                                     4,
                                     5,
                                     1,
                                     2,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);


    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     intellectualStar1,
                                     1,
                                     2,
                                     2,
                                     3,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     intellectualStar2,
                                     2,
                                     3,
                                     2,
                                     3,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     intellectualStar3,
                                     3,
                                     4,
                                     2,
                                     3,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    gtk_table_attach ( GTK_TABLE( biorhythmDataTable ),
                                     intellectualStar4,
                                     4,
                                     5,
                                     2,
                                     3,
                                     GTK_SHRINK,
                                     GTK_EXPAND | GTK_FILL,
                                     0,
                                     0.5);

    /* END ATTACHING STARS */



    /* END BIORHYTHM RATE */

    /* SETTING DEFAULT HIGHLIGHTED DAY */
    GDate *currentSelectedDate;
    
    currentSelectedDate = g_date_new_dmy(
					g_date_get_day( applicationData->currentReferenceDate ),
					g_date_get_month( applicationData->currentReferenceDate ),
					g_date_get_year( applicationData->currentReferenceDate )
	);
	applicationData->currentSelectedDate = currentSelectedDate;

    /* START SELECTED DAY */

    GtkWidget *selectedDayContainer;

    selectedDayContainer = gtk_vbox_new( FALSE, 0 );

    gtk_widget_set_size_request ( selectedDayContainer,
                                                        -1,
                                                        OSSO_ABOOK_PIXEL_SIZE_AVATAR_MEDIUM);

    

	gchar selectedDayString[128];
	g_date_strftime( (gchar*) selectedDayString, sizeof( selectedDayString ), "%x", applicationData->currentSelectedDate );
    
    biorhythmUpdatableWidgets->selectedDateLabel = GTK_LABEL( gtk_label_new( selectedDayString ) );

    gtk_box_pack_start ( GTK_BOX( selectedDayContainer ),
                                        GTK_WIDGET( biorhythmUpdatableWidgets->selectedDateLabel ),
                                        TRUE,
                                        TRUE,
                                        0);

    GtkWidget *selectedDayButtonsContainer;

    selectedDayButtonsContainer = gtk_hbox_new( FALSE, 0 );


    GtkWidget *selectPreviousDayButton;

    selectPreviousDayButton = hildon_gtk_button_new( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH );
	
	biorhythmUpdatableWidgets->previousReferenceDayButton = GTK_BUTTON( selectPreviousDayButton );
	
    gtk_button_set_image ( GTK_BUTTON( selectPreviousDayButton ),
                                              gtk_image_new_from_stock ( GTK_STOCK_GO_BACK, HILDON_ICON_SIZE_FINGER )
                                                           );

    gtk_box_pack_start ( GTK_BOX( selectedDayButtonsContainer ),
                                        selectPreviousDayButton,
                                        TRUE,
                                        TRUE,
                                        0);



    gtk_box_pack_start ( GTK_BOX( selectedDayContainer ),
                                        selectedDayButtonsContainer,
                                        TRUE,
                                        FALSE,
                                        0);


    GtkWidget *selectNextDayButton;

    selectNextDayButton = hildon_gtk_button_new( HILDON_SIZE_FINGER_HEIGHT | HILDON_SIZE_AUTO_WIDTH );

	biorhythmUpdatableWidgets->nextReferenceDayButton = GTK_BUTTON( selectNextDayButton );

    gtk_button_set_image ( GTK_BUTTON( selectNextDayButton ),
                                              gtk_image_new_from_stock ( GTK_STOCK_GO_FORWARD, HILDON_ICON_SIZE_FINGER )
                                                           );

    gtk_box_pack_start ( GTK_BOX( selectedDayButtonsContainer ),
                                        selectNextDayButton,
                                        TRUE,
                                        TRUE,
                                        0);

    gtk_box_pack_end ( GTK_BOX( topContactData ),
                                        selectedDayContainer,
                                        TRUE,
                                        TRUE,
                                        HILDON_MARGIN_DEFAULT);

    /* END SELECTED DAY */ 

     g_signal_connect( selectNextDayButton,
                                "clicked",
                                G_CALLBACK(nextReferenceDayButtonClicked),
                                applicationData);
     g_signal_connect( selectPreviousDayButton,
                                "clicked",
                                G_CALLBACK(previousReferenceDayButtonClicked),
                                applicationData);    


    gtk_box_pack_start ( GTK_BOX ( mainContainer ),
                                        topContactData,
                                        FALSE,
                                        FALSE,
                                       0);    

    /* START CHART LEGEND */

    GtkWidget *legendContainer;
    GtkWidget *physicalLegendLabel, *emotionalLegendLabel, *intellectualLegendLabel;
    GtkWidget *physicalLegendImage, *emotionalLegendImage, *intellectualLegendImage;

    legendContainer = gtk_hbox_new( FALSE, HILDON_MARGIN_DEFAULT );

    physicalLegendLabel = gtk_label_new( "Physical" );
    emotionalLegendLabel = gtk_label_new( "Emotional" );
    intellectualLegendLabel = gtk_label_new( "Intellectual" );

    physicalLegendImage = gtk_image_new_from_file( MARHYTHM_IMAGE_PHYSICAL_LEGEND_PATH );
    emotionalLegendImage = gtk_image_new_from_file( MARHYTHM_IMAGE_EMOTIONAL_LEGEND_PATH );
    intellectualLegendImage = gtk_image_new_from_file( MARHYTHM_IMAGE_INTELLECTUAL_LEGEND_PATH );

    gtk_misc_set_alignment ( GTK_MISC( physicalLegendLabel ),
                                        0.0,
                                        0.5 );
    gtk_misc_set_alignment ( GTK_MISC( emotionalLegendLabel ),
                                        0.0,
                                        0.5 );
    gtk_misc_set_alignment ( GTK_MISC( intellectualLegendLabel ),
                                        0.0,
                                        0.5 );

     gtk_misc_set_alignment ( GTK_MISC( physicalLegendImage ),
                                        1.0,
                                        0.5 );
    gtk_misc_set_alignment ( GTK_MISC( emotionalLegendImage ),
                                        1.0,
                                        0.5 );
    gtk_misc_set_alignment ( GTK_MISC( intellectualLegendImage ),
                                        1.0,
                                        0.5 );


    gtk_box_pack_start( GTK_BOX( legendContainer ),
                                        physicalLegendImage,
                                        TRUE,
                                        TRUE,
                                        0 );

    gtk_box_pack_start( GTK_BOX( legendContainer ),
                                        physicalLegendLabel,
                                        TRUE,
                                        TRUE,
                                        0 );

    gtk_box_pack_start( GTK_BOX( legendContainer ),
                                        emotionalLegendImage,
                                        TRUE,
                                        TRUE,
                                        0 );

    gtk_box_pack_start( GTK_BOX( legendContainer ),
                                        emotionalLegendLabel,
                                        TRUE,
                                        TRUE,
                                        0 );

 gtk_box_pack_start( GTK_BOX( legendContainer ),
                                        intellectualLegendImage,
                                        TRUE,
                                        TRUE,
                                        0 );

    gtk_box_pack_start( GTK_BOX( legendContainer ),
                                        intellectualLegendLabel,
                                        TRUE,
                                        TRUE,
                                        0 );

    gtk_box_pack_start ( GTK_BOX ( mainContainer ),
                                        legendContainer,
                                        FALSE,
                                        FALSE,
                                        0); 

    /* END CHART LEGEND */


    /* START BIORHYTHM CHART */

    GtkWidget *biorhythmChart;
    biorhythmChart = mr_biorhythm_chart_new();

    biorhythmUpdatableWidgets->biorhythmChart = MR_BIORHYTHM_CHART( biorhythmChart );

    gtk_widget_set_size_request ( biorhythmChart,
                                                        1500,
                                                        -1);

    GtkWidget *biorhythmChartPannableArea;
    biorhythmChartPannableArea = hildon_pannable_area_new();

    g_object_set( G_OBJECT( biorhythmChartPannableArea ),
                            "mov-mode",
                            HILDON_MOVEMENT_MODE_HORIZ,
                            NULL );

    hildon_pannable_area_add_with_viewport (HILDON_PANNABLE_AREA( biorhythmChartPannableArea ),
                                                         biorhythmChart);

    gtk_box_pack_end ( GTK_BOX ( mainContainer ),
                                        biorhythmChartPannableArea,
                                        TRUE,
                                        TRUE,
                                        0); 

    /* END BIORHYTHM CHART */

    /* START CONNECTING SIGNALS */
/*
    g_signal_connect_after( G_OBJECT( biorhythmChart ),
                                        "highlight-changed",
                                        G_CALLBACK(chartHighlightChanged),
                                        applicationData );

*/
    /* END CONNECTING SIGNALS */

    gtk_container_add( GTK_CONTAINER( personalBiorhythmWindow ), mainContainer );   


    g_object_set( G_OBJECT( biorhythmChart ),
                            "reference-date",
                            applicationData->currentReferenceDate,
                            NULL);
    

    g_object_set( G_OBJECT( biorhythmChart ),
                            "birth-date",
                            birthDate,
                            NULL);

    GDate *highlightDate;
    
    highlightDate = applicationData->currentSelectedDate;

    g_object_set( G_OBJECT( biorhythmChart ),
                            "highlight-date",
                            highlightDate,
                            NULL);

    gtk_widget_show_all( personalBiorhythmWindow );

}



void
marhythm_display_personal_biorhythm( MarhythmData *applicationData )
{
    OssoABookSelfContact *selfContact;

    selfContact = osso_abook_self_contact_get_default();

   marhythm_display_biorhythm( applicationData, OSSO_ABOOK_CONTACT( selfContact ) );
}

void
marhythm_display_contacts_by_abc( MarhythmData *applicationData )
{
    OssoABookListStore *contactModel;

    contactModel = osso_abook_tree_view_get_base_model ( OSSO_ABOOK_TREE_VIEW(applicationData->contactListView) );
    osso_abook_list_store_set_contact_order( contactModel, OSSO_ABOOK_CONTACT_ORDER_NAME );
}


void
marhythm_display_contacts_by_availability( MarhythmData *applicationData )
{
    OssoABookListStore *contactModel;

    contactModel = osso_abook_tree_view_get_base_model ( OSSO_ABOOK_TREE_VIEW(applicationData->contactListView) );
    osso_abook_list_store_set_contact_order( contactModel, OSSO_ABOOK_CONTACT_ORDER_PRESENCE );

}

void 
marhythm_set_biorhythm_contact( MarhythmData *applicationData, OssoABookContact *contact )
{
    EContactDate *contactBirthDate; 
    GDate *birthDate;
    MrBiorhythmChart *biorhythmChart;

    contactBirthDate = e_contact_get(  E_CONTACT( contact ),  E_CONTACT_BIRTH_DATE);

    birthDate = g_date_new_dmy( contactBirthDate->day, contactBirthDate->month, contactBirthDate->year );

    biorhythmChart = MR_BIORHYTHM_CHART( applicationData->biorhythmChart );

    g_object_set( G_OBJECT( biorhythmChart ), "birth-date", birthDate, NULL );    
}

void
marhythm_set_biorhythm_reference_date( MarhythmData *applicationData, GDate *referenceDate )
{    
    MrBiorhythmChart *biorhythmChart;

    biorhythmChart = MR_BIORHYTHM_CHART(applicationData->biorhythmChart);

    g_object_set( G_OBJECT(biorhythmChart), "reference-date", referenceDate, NULL );
}

void 
connectSignals( MarhythmData *applicationData )
{

    g_signal_connect_after( applicationData->personalBiorhythmButton,
                                        "clicked",
                                        G_CALLBACK(personalBiorhythmClicked),
                                        applicationData );
    
	g_signal_connect_after( applicationData->aboutButton,
									"clicked",
									G_CALLBACK(aboutButtonClicked),
									applicationData );

    g_signal_connect_after( applicationData->filterByABCButton,
                                        "toggled",
                                        G_CALLBACK(filterButtonToggled),
                                        applicationData );

    g_signal_connect_after( applicationData->filterByAvailabilityButton,
                                        "toggled",
                                        G_CALLBACK(filterButtonToggled),
                                        applicationData );

     g_signal_connect( applicationData->contactListView,
                                        "contact-activated",
                                        G_CALLBACK(contactActivated),
                                        applicationData );

  	g_signal_connect( applicationData->mainWindow, "destroy", G_CALLBACK( gtk_main_quit ), NULL);
}

void
createContactList( MarhythmData *applicationData )
{
    GtkWidget *mainWindow = applicationData->mainWindow;
    GtkWidget *contactList;
    OssoABookContactModel *defaultModel;
    
    defaultModel = osso_abook_contact_model_get_default();

    contactList = osso_abook_contact_view_new_basic( HILDON_UI_MODE_NORMAL, defaultModel );
    
    applicationData->contactListView = contactList;

    gtk_container_add( GTK_CONTAINER (mainWindow), GTK_WIDGET(contactList)  );

    marhythm_display_contacts_by_abc( applicationData );

    gtk_widget_show( contactList );

}

void marhythm_set_default_current_reference_date( MarhythmData *applicationData )
{
    GDate *currentDate;
    GTimeVal currentTime;    
    g_get_current_time ( &currentTime );


    currentDate = g_date_new ();

    g_date_set_time_val ( currentDate,
                                                         &currentTime);

    applicationData->currentReferenceDate = currentDate;
}

void createApplicationMenu( MarhythmData *applicationData )
{
    GtkWidget *applicationMenu;
    GtkWindow *mainWindow;

    GtkWidget *abcFilterButton;
    GtkWidget *availabilityFilterButton;

    GtkWidget *personalBiorhythmButton;
    GtkWidget *aboutButton;

    GSList *filterGroup;    

    mainWindow = GTK_WINDOW( applicationData->mainWindow );

    personalBiorhythmButton = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
								 HILDON_BUTTON_ARRANGEMENT_VERTICAL,
								"Personal Biorhythm",
								NULL);
	aboutButton = hildon_button_new_with_text(HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT,
					 HILDON_BUTTON_ARRANGEMENT_VERTICAL,
					"About",
					NULL);
                                                                                                
                                                                                                

    applicationMenu = hildon_app_menu_new();

    /* Creating filter buttons */
    abcFilterButton = gtk_radio_button_new_with_label( NULL, "ABC" );
    filterGroup = gtk_radio_button_get_group( GTK_RADIO_BUTTON( abcFilterButton ) );
    gtk_toggle_button_set_mode( GTK_TOGGLE_BUTTON( abcFilterButton ), FALSE);  
    applicationData->filterByABCButton = abcFilterButton;

    availabilityFilterButton = gtk_radio_button_new_with_label_from_widget( GTK_RADIO_BUTTON( abcFilterButton ), "Availability");
    gtk_toggle_button_set_mode( GTK_TOGGLE_BUTTON( availabilityFilterButton ), FALSE);
    applicationData->filterByAvailabilityButton = availabilityFilterButton;

    /* Adding filters */
    hildon_app_menu_add_filter( HILDON_APP_MENU( applicationMenu ), GTK_BUTTON( abcFilterButton ) );
    hildon_app_menu_add_filter( HILDON_APP_MENU( applicationMenu ), GTK_BUTTON( availabilityFilterButton ) );

    /* Adding action buttons to menu */
    hildon_app_menu_append( HILDON_APP_MENU( applicationMenu ), GTK_BUTTON( personalBiorhythmButton ) );
    hildon_app_menu_append( HILDON_APP_MENU( applicationMenu ), GTK_BUTTON( aboutButton ) );

    /* Setting application menu */
    hildon_window_set_app_menu( HILDON_WINDOW( mainWindow ), HILDON_APP_MENU( applicationMenu ) );

    // Referencing buttons to the application data   
    applicationData->personalBiorhythmButton = personalBiorhythmButton;
    applicationData->aboutButton = aboutButton;

    gtk_widget_show_all (GTK_WIDGET (applicationMenu) );    
}

void marhythm_init( MarhythmData *applicationData  )
{
    HildonProgram *program;	
    GtkWidget *mainWindow;

    program = hildon_program_get_instance ();

	mainWindow = hildon_stackable_window_new();
    hildon_program_add_window (program, HILDON_WINDOW( mainWindow ) );

    // Linking data
    applicationData->mainWindow = mainWindow;

    //Creating application menu
    createApplicationMenu( applicationData );

    //Creating contact list
    createContactList( applicationData );

    //Connecting signals
    connectSignals( applicationData );

    // Setting default reference date
    marhythm_set_default_current_reference_date( applicationData );

	gtk_widget_show_all( mainWindow );

}
