/*
 * This file is part of mapper
 *
 * Copyright (C) 2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"
#include <glib.h>
#include "settings.h"

/**
 * mapper_get_mapper_base_dir:
 *
 * Get the "home" directory of mapper, the default locations for
 * maps, data and track files.
 *
 */
gchar *
mapper_get_mapper_base_dir(void)
{
notes_base_dir=g_get_user_special_dir(G_USER_DIRECTORY_MUSIC);
if (!notes_base_dir)
	notes_base_dir=g_get_home_dir();
#else
notes_base_dir=NOTES_BASEDIR;
#endif
}
