#ifndef _MAPPER_HILDON_WRAPPERS_H
#define _MAPPER_HILDON_WRAPPERS_H

/****************************************************************************
 * Wrappers and defines for non-hildon build
 ****************************************************************************/

#include "config.h"
#include <gtk/gtk.h>
#include "hildon-mapper.h"

#ifdef WITH_HILDON
void force_min_visible_bars(HildonControlbar *control_bar, gint num_bars);
#else
void force_min_visible_bars(GtkWidget *a, gint b);
#endif


#ifndef WITH_HILDON
/* Define hildon key to use gdk keys */
#define HILDON_HARDKEY_UP			GDK_Up
#define HILDON_HARDKEY_DOWN			GDK_Down
#define HILDON_HARDKEY_LEFT			GDK_Left
#define HILDON_HARDKEY_RIGHT		GDK_Right
#define HILDON_HARDKEY_SELECT		GDK_F2
#define HILDON_HARDKEY_FULLSCREEN	GDK_F10
#define HILDON_HARDKEY_INCREASE 	GDK_F6
#define HILDON_HARDKEY_DECREASE 	GDK_F5
#define HILDON_HARDKEY_ESC			GDK_Escape
#define HILDON_COLOR_BUTTON 		GTK_COLOR_BUTTON

#define HILDON_COLOR_BUTTON 	GTK_COLOR_BUTTON

#define hildon_color_button_new gtk_color_button_new
#define hildon_color_button_set_color gtk_color_button_set_color
#define HILDON_BANNER(a) a
#define HILDON_CONTROLBAR(a) a
#define HILDON_NUMBER_EDITOR(a) a

#define hildon_note_new_information(aw, be) gtk_message_dialog_new (GTK_WINDOW (aw), \
				   GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, \
				   GTK_MESSAGE_INFO, GTK_BUTTONS_OK, be);

GtkWidget *hildon_file_chooser_dialog_new(GtkWindow * parent, GtkFileChooserAction action);
void hildon_banner_show_information(GtkWidget *w, void *t, gchar *text);
GtkWidget *hildon_note_new_confirmation(GtkWindow *widget, const gchar *text);
GtkWidget *hildon_banner_show_progress(GtkWidget * widget, GtkProgressBar *bar, const gchar * text);
void hildon_banner_set_fraction(GtkWidget * widget, gdouble fraction);
GtkWidget *hildon_banner_show_animation(GtkWidget *widget,
					const gchar *animation_name,
					const gchar *text);
GtkWidget *hildon_number_editor_new(gint min, gint max);
gint hildon_number_editor_get_value(GtkWidget * w);
void hildon_number_editor_set_value(GtkWidget * w, gint v);
void hildon_number_editor_set_range(GtkWidget * w, gint min, gint max);
GtkWidget *hildon_controlbar_new();
gint hildon_controlbar_get_value(GtkWidget * w);
void hildon_controlbar_set_value(GtkWidget * w, gint v);
void hildon_controlbar_set_range(GtkWidget * w, gint min, gint max);

#endif

#ifndef WITH_DEVICE_MAEMO
#define HWK_BUTTON_UP			GDK_Up
#define HWK_BUTTON_DOWN			GDK_Down
#define HWK_BUTTON_LEFT			GDK_Left
#define HWK_BUTTON_RIGHT		GDK_Right
#define HWK_BUTTON_SELECT		GDK_Return
#define HWK_BUTTON_VIEW			GDK_F10
#define HWK_BUTTON_INCREASE 	GDK_F6
#define HWK_BUTTON_DECREASE 	GDK_F5
#define HWK_BUTTON_CANCEL		GDK_Escape
#endif

#endif
