/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 * Copyright (C) 2006-2007 John Costigan.
 *
 * POI and GPS-Info code originally written by Cezary Jackiewicz.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <config.h>
#include <unistd.h>
#include <stdlib.h>
#include <stddef.h>
#include <errno.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <fcntl.h>
#include <dbus/dbus-glib.h>

#include "hildon-mapper.h"

static GtkWidget *connect_banner = NULL;
static GtkWidget *fix_banner = NULL;

#include "utils.h"
#include "settings.h"
#include "gps.h"
#include "map.h"
#include "ui-common.h"
#include "gps-conn.h"

/**
 * Set the connection state. This function controls all connection-related banners.
 */
void 
gps_conn_set_state(Gps *gps, GpsConnState new_conn_state)
{
switch (gps->io.conn=new_conn_state) {
	case RCVR_OFF:
		set_action_activate("gps_enabled", FALSE);
	case RCVR_FIXED:
		if (connect_banner) {
			gtk_widget_destroy(connect_banner);
			connect_banner=NULL;
		}
		if (fix_banner) {
			gtk_widget_destroy(fix_banner);
			fix_banner=NULL;
		}
#ifndef WITH_HILDON
		gtk_progress_bar_set_text(GTK_PROGRESS_BAR(mapp.progress), "");
		gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(mapp.progress), 0.0);
#endif
		break;
	case RCVR_DOWN:
		if (fix_banner) {
			gtk_widget_destroy(fix_banner);
			fix_banner=NULL;
		}
		if (!connect_banner)
			connect_banner=hildon_banner_show_animation(mapp.mainwindow, NULL, _("Searching for GPS receiver"));
		break;
	case RCVR_UP:
		if (connect_banner) {
			gtk_widget_destroy(connect_banner);
			connect_banner=NULL;
		}
		if (!fix_banner)
			fix_banner=hildon_banner_show_progress(mapp.mainwindow, NULL, _("Establishing GPS fix"));
		break;
	default:;		/* to quell warning. */
}
}

void
gps_conn_set_progress(Gps *gps, gdouble fix)
{
#ifdef WITH_HILDON
hildon_banner_set_fraction(fix_banner, fix);
#else
gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(mapp.progress), fix);
#endif
}
