/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 * Copyright (C) 2006-2007 John Costigan.
 *
 * POI and GPS-Info code originally written by Cezary Jackiewicz.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <config.h>

#include <fcntl.h>

#include "mapper.h"
#include "gps-bluetooth-bluez-marshal.h"
#include "gps.h"
#include "settings.h"
#include "ui-common.h"
#include "gps-conn.h"

/**
 * Bluetooth device scanning functions below
 */
static void
scan_dev_found_cb(DBusGProxy *object, const char *address, const unsigned int class, const int rssi, GpsScanInfo *scan_info)
{
GtkTreeIter iter;

gtk_list_store_append(scan_info->store, &iter);
gtk_list_store_set(scan_info->store, &iter, 0, g_strdup(address), 1, g_strdup(name), -1);
}

static void 
scan_search_complete_cb(DBusGProxy *sig_proxy, GpsScanInfo *scan_info)
{
gtk_widget_destroy(scan_info->banner);
dbus_g_proxy_disconnect_signal(sig_proxy, BTSEARCH_DEV_FOUND_SIG, G_CALLBACK(scan_cb_dev_found), scan_info);
dbus_g_proxy_disconnect_signal(sig_proxy, BTSEARCH_SEARCH_COMPLETE_SIG, G_CALLBACK(scan_cb_search_complete), scan_info);
}

GpsScanResult 
gps_scan_start_search(GpsScanInfo * scan_info)
{
GError *error=NULL;

if (NULL == (scan_info->req_proxy = dbus_g_proxy_new_for_name(bus, "org.bluez", "/org/bluez/hci0", "org.bluez.Adapter"))) {
	g_printerr("Failed to create D-Bus request proxy for btsearch.");
	return GPS_SCAN_FAIL;
}

dbus_g_object_register_marshaller(marshal_VOID__STRING_UINT_INT, G_TYPE_NONE, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INT, G_TYPE_INVALID);

dbus_g_proxy_add_signal(scan_info->req_proxy, "RemoteDeviceFound", G_TYPE_STRING, G_TYPE_UINT, G_TYPE_INT, G_TYPE_INVALID);
dbus_g_proxy_connect_signal(scan_info->req_proxy, "RemoteDeviceFound", G_CALLBACK(scan_dev_found_cb), bus, NULL);

dbus_g_proxy_add_signal(scan_info->req_proxy, "DiscoveryCompleted", G_TYPE_INVALID);
dbus_g_proxy_connect_signal(scan_info->req_proxy, "DiscoveryCompleted", G_CALLBACK(scan_search_complete_cb), bus, NULL);

#if 0
dbus_g_object_register_marshaller(marshal_VOID__STRING_STRING, G_TYPE_NONE, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
dbus_g_proxy_add_signal(scan_info->req_proxy, "RemoteNameUpdated", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID);
dbus_g_proxy_connect_signal(scan_info->req_proxy, "RemoteNameUpdated", G_CALLBACK(scan_dev_found_cb), NULL, NULL);
#endif

error = NULL;
if (!dbus_g_proxy_call(obj, "DiscoverDevices", &error, G_TYPE_INVALID, G_TYPE_INVALID)) {
	if (error->domain==DBUS_GERROR && error->code == DBUS_GERROR_REMOTE_EXCEPTION) {
		g_printerr("Caught remote method exception %s: %s", dbus_g_error_get_name(error), error->message);
	} else {
		g_printerr("Error: %s\n", error->message);
	}
	return GPS_SCAN_ERROR;
}

return GPS_SCAN_OK;
}

gboolean
gps_scan_stop_search(GpsScanInfo *scan_info)
{

return TRUE;
}
