/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <stddef.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <locale.h>

#include "hildon-mapper.h"
#include "utils.h"
#include "osm-db-import.h"
#include "dialogs.h"
#include "import-gui.h"

static GtkWidget *progress;
static GtkWidget *import_dialog;

static gboolean
osm_import_progress_cb(gpointer data)
{
gtk_progress_bar_pulse(GTK_PROGRESS_BAR(progress));
return TRUE;
}

static gboolean
osm_import_done_cb(gpointer data)
{
gint ret;

ret=osm_import_join_bg();

if (ret!=0)
	popup_error(import_dialog, _("OSM Data import failed!"));

progress_dialog_remove(import_dialog);
return FALSE;
}

gboolean
osm_import_dialog(GtkWidget *window)
{
GtkWidget *dialog;
GtkWidget *vbox;
GtkWidget *picker_planet;
GtkWidget *entry_db;

dialog = gtk_dialog_new_with_buttons(_("OSM Data import"),
				GTK_WINDOW(window),
				GTK_DIALOG_MODAL, GTK_STOCK_OK, GTK_RESPONSE_ACCEPT, 
				GTK_STOCK_CANCEL, GTK_RESPONSE_REJECT, NULL);

gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), vbox = gtk_vbox_new (FALSE, 3), TRUE, TRUE, 0);

picker_planet=gtk_file_chooser_button_new(_("OSM Planet file"), GTK_FILE_CHOOSER_ACTION_OPEN);
entry_db=gtk_entry_new();

gtk_box_pack_start(GTK_BOX(vbox), gtk_label_new("OSM Planet"), TRUE, TRUE, 0);
gtk_box_pack_start(GTK_BOX(vbox), picker_planet, TRUE, TRUE, 0);

gtk_box_pack_start(GTK_BOX(vbox), gtk_label_new("Destination database"), TRUE, TRUE, 0);
gtk_box_pack_start(GTK_BOX(vbox), entry_db, TRUE, TRUE, 0);

gtk_widget_show_all(dialog);

while (GTK_RESPONSE_ACCEPT==gtk_dialog_run(GTK_DIALOG(dialog))) {
	gchar *planet, *db;

	planet=gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(picker_planet));
	db=gtk_entry_get_text(GTK_ENTRY(entry_db));

	if (planet && db) {
		progress=gtk_progress_bar_new();
		import_dialog=progress_dialog(window, "Import", gtk_label_new(_("Importing OSM data, please wait...")), progress);
		gtk_widget_show_all(import_dialog);

		if (osm_import_bg(planet, db, osm_import_progress_cb, osm_import_done_cb)==TRUE) {
			break;
		} else
			popup_error(dialog, _("Failed to start import."));
	} else {
		popup_error(dialog, _("Missing file selection!"));
	}
}
gtk_widget_destroy(dialog);
return TRUE;
}
