/*
 * This file is part of mapper
 *
 * Copyright (C) 2007-2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * UI Menu and toolbar for Hildon/Maemo 2 and 4 (and 5 for now)
 *
 * Should be included from ui-common.c ONLY
 */
 
static const gchar *mapper_ui =
"<ui>"
"  <menubar name='MenuBar'>"
"    <menuitem action='gps_enabled'/>"
"    <menu action='file'>"
"      <menuitem action='file_settings_gps'/>"
"      <menuitem action='file_settings_generic'/>"
"      <menuitem action='file_settings_colors'/>"
"      <menuitem action='file_settings_osm'/>"
"      <menuitem action='file_settings_keys'/>"
"      <menuitem action='track_filter'/>"
"      <separator/>"
"      <menuitem action='file_import_osm'/>"
"    </menu>"
"    <menu action='map' name='map'>"
"      <menu action='map_maps' name='map_maps'></menu>"
"      <menuitem action='map_manager'/>"
"      <menuitem action='map_auto_download'/>"
"      <separator/>"
"      <menuitem action='autocenter_latlon'/>"
"      <menuitem action='autocenter_lead'/>"
"      <menuitem action='autocenter_none'/>"
"    </menu>"
"    <menuitem action='search_address'/>"
"    <menu action='track'>"
"      <menuitem action='track_insert_mark'/>"
"      <menuitem action='track_insert_break'/>"
"      <separator/>"
"      <menuitem action='track_dist_last_mark'/>"
"      <menuitem action='track_dist_first'/>"
"    </menu>"
"    <menu action='route'>"
"      <menuitem action='route_dist_next'/>"
"      <menuitem action='route_dist_last'/>"
"      <menuitem action='route_reset'/>"
"      <menuitem action='route_clear'/>"
"    </menu>"
"    <menu action='poi'>"
"      <menuitem action='poi_categories'/>"
"      <menuitem action='poi_search'/>"
"    </menu>"
"    <menu action='view'>"
"      <menuitem action='view_zoom_normal'/>"
"      <menuitem action='view_zoom_auto'/>"
"      <separator/>"
"      <menuitem action='view_route'/>"
"      <menuitem action='view_track'/>"
"      <menuitem action='view_poi'/>"
"      <menuitem action='view_scale'/>"
"      <menuitem action='view_vector'/>"
"      <separator/>"
"      <menuitem action='view_toolbar'/>"
"    </menu>"
"    <menu action='goto'>"
"      <menuitem action='goto_home'/>"
"      <menuitem action='goto_destination'/>"
"      <menuitem action='goto_gps'/>"
"      <menuitem action='goto_latlon'/>"
"      <menuitem action='goto_nearpoi'/>"
"      <menuitem action='goto_nextway'/>"
"    </menu>"
"    <menu action='audio'>"
"      <menuitem action='audio_button_toggle_record'/>"
"    </menu>"
"    <menuitem action='help_about'/>"
"  </menubar>"
"  <toolbar name='ToolBar'>"
"    <toolitem action='goto_home'/>"
"    <toolitem action='goto_destination'/>"
"    <toolitem action='goto_gps'/>"
"    <toolitem action='poi_add'/>"
"    <toolitem action='poi_quick_add'/>"
"    <toolitem action='track_insert_mark'/>"
"    <toolitem action='search_address'/>"
#if defined (WITH_MAEMO_VER) && WITH_MAEMO_VER<5
"    <toolitem action='view_zoom_in'/>"
"    <toolitem action='view_zoom_out'/>"
#endif
#if defined (WITH_MAEMO_VER) && WITH_MAEMO_VER>=5
"    <toolitem action='view_fullscreen'/>"
#endif
"  </toolbar>"
"  <toolbar name='MappingToolBar'>"
"    <toolitem action='goto_gps'/>"
"    <separator/>"
"    <toolitem action='poi_add'/>"
"    <toolitem action='poi_quick_add'/>"
"    <toolitem action='track_insert_break'/>"
"    <toolitem action='track_insert_mark'/>"
"    <separator/>"
"    <toolitem action='search_address'/>"
"  </toolbar>"
"</ui>";
