/*
 * This file is part of mapper
 *
 * Copyright (C) 2007-2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/**
 * UI Menu and toolbar for Desktop
 *
 * Should be included from ui-common.c ONLY
 */
 
static const gchar *mapper_ui =
"<ui>"
"  <menubar name='MenuBar'>"
"    <menu action='file'>"
"      <menu action='file_settings'>"
"       <menuitem action='file_settings_gps'/>"
"       <menuitem action='file_settings_generic'/>"
"       <menuitem action='file_settings_colors'/>"
"       <separator/>"
"       <menuitem action='file_settings_osm'/>"
"	</menu>"
"      <separator/>"
"      <menuitem action='file_import_osm'/>"
"      <menuitem action='file_quit'/>"
"    </menu>"
"    <menu action='map' name='map'>"
"      <menu action='map_maps' name='map_maps'>"
"      </menu>"
"      <separator/>"
"      <menuitem action='map_manager'/>"
"      <separator/>"
"      <menuitem action='map_auto_download'/>"
"      <separator/>"
"     <menu action='autocenter'>"
"      <menuitem action='autocenter_latlon'/>"
"      <menuitem action='autocenter_lead'/>"
"      <menuitem action='autocenter_none'/>"
"     </menu>"
"      <separator/>"
"      <menuitem action='view_scale'/>"
"      <menuitem action='view_vector'/>"
"    </menu>"
"    <menu action='search'>"
"      <menuitem action='search_address'/>"
"    </menu>"
"    <menu action='track'>"
"      <menuitem action='track_open'/>"
"      <menuitem action='track_save'/>"
"      <menuitem action='track_clear'/>"
"      <separator/>"
"      <menuitem action='track_insert_break'/>"
"      <menuitem action='track_insert_mark'/>"
"      <separator/>"
"      <menuitem action='track_dist_last_mark'/>"
"      <menuitem action='track_dist_first'/>"
"      <separator/>"
"      <menuitem action='track_filter'/>"
"      <separator/>"
"      <menuitem action='view_track'/>"
"    </menu>"
"    <menu action='route'>"
"      <menuitem action='route_open'/>"
"      <menuitem action='route_save'/>"
"      <menuitem action='route_download'/>"
"      <separator/>"
"      <menuitem action='route_dist_next'/>"
"      <menuitem action='route_dist_last'/>"
"      <separator/>"
"      <menuitem action='route_reset'/>"
"      <menuitem action='route_clear'/>"
"      <separator/>"
"      <menuitem action='view_route'/>"
"    </menu>"
"    <menu action='poi'>"
"      <menuitem action='poi_categories'/>"
"      <menuitem action='poi_search'/>"
"      <separator/>"
"      <menuitem action='view_poi'/>"
"    </menu>"
"    <menu action='view'>"
"      <menuitem action='view_zoom_in'/>"
"      <menuitem action='view_zoom_out'/>"
"      <menuitem action='view_zoom_normal'/>"
"      <menuitem action='view_zoom_auto'/>"
"      <separator/>"
"      <menuitem action='view_fullscreen'/>"
"      <menuitem action='view_toolbar'/>"
"    </menu>"
"    <menu action='goto'>"
"      <menuitem action='goto_home'/>"
"      <menuitem action='goto_destination'/>"
"      <menuitem action='goto_gps'/>"
"      <separator/>"
"      <menuitem action='goto_latlon'/>"
"      <menuitem action='goto_nearpoi'/>"
"      <menuitem action='goto_nextway'/>"
"      <separator/>"
"    </menu>"
"    <menu action='gps'>"
"      <menuitem action='gps_enabled'/>"
"    </menu>"
"    <menu action='audio'>"
"      <menuitem action='audio_button_toggle_record'/>"
"    </menu>"
"    <menu action='help'>"
"      <menuitem action='help_about'/>"
"    </menu>"
"  </menubar>"
"  <toolbar name='ToolBar'>"
"    <toolitem action='goto_home'/>"
"    <toolitem action='goto_destination'/>"
"    <toolitem action='goto_gps'/>"
"    <separator/>"
"    <toolitem action='poi_add'/>"
"    <toolitem action='poi_quick_add'/>"
"    <separator/>"
"    <toolitem action='track_insert_mark'/>"
"    <separator/>"
"    <toolitem action='search_address'/>"
"    <separator/>"
"    <toolitem action='view_zoom_in'/>"
"    <toolitem action='view_zoom_out'/>"
"    <toolitem action='view_zoom_normal'/>"
"    <toolitem action='view_zoom_auto'/>"
"    <toolitem action='view_fullscreen'/>"
"    <separator/>"
"  </toolbar>"
"  <toolbar name='MappingToolBar'>"
"    <toolitem action='goto_gps'/>"
"    <separator/>"
"    <toolitem action='poi_add'/>"
"    <toolitem action='poi_quick_add'/>"
"    <toolitem action='track_insert_break'/>"
"    <toolitem action='track_insert_mark'/>"
"    <separator/>"
"    <toolitem action='search_address'/>"
"  </toolbar>"
"</ui>";
