/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 * Copyright (C) 2006-2007 John Costigan.
 *
 * POI and GPS-Info code originally written by Cezary Jackiewicz.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef _MAPPER_POI_GUI_H
#define _MAPPER_POI_GUI_H

#include <glib.h>
#include "poi.h"

/** POI dialog action **/
typedef enum {
	ACTION_ADD_POI,
	ACTION_EDIT_POI,
} POIAction;

/* Quick POI information structure */
typedef struct _poi_quick_data poi_quick_data;
struct _poi_quick_data {
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *note;
	gint tab;
	gboolean fixed;
	gboolean close;
	gdouble lat;
	gdouble lon;
};

gboolean poi_select(guint unitx, guint unity, guint range, poi_info *poi);
gboolean poi_edit_dialog(POIAction action, poi_info *poi);
gboolean poi_search_dialog(GtkListStore *store, poi_info *poi, gdouble lat, gdouble lon);
GtkWidget *poi_quick_button_box(poi_quick_data *qpdata);
gboolean poi_quick_dialog(gdouble lat, gdouble lon);

gboolean poi_info_dialog(GtkWidget *window, guint poi_id);

gboolean poi_category_dialog(guint cat_id);
gboolean poi_category_list();

void poi_category_combo_populate(GtkWidget *cmb_category, guint cat_id, gboolean add_na);
GtkWidget *category_combo_new(void);

#endif
