/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef _OSM_H
#define _OSM_H

/* Flags */
#define W_NONE		(0)
#define W_ONEWAY 	(1 << 1)
#define W_ROUNDABOUT 	(1 << 2)
#define W_LINK		(1 << 3)
#define W_AREA		(1 << 4)
#define W_NOEXIT	(1 << 5)
#define W_NOACCESS	(1 << 6)
#define W_NONAME	(1 << 7)
#define W_NOREF		(1 << 8)

#define ILAT_TURKU 911084432
#define ILON_TURKU 265542144

/* POI category ID's are special, the # is divied 
 * by 100 and the result is the importance/priority of the poi.
 * This can be used by the client program to discard 
 * unimportant poi at different zoom levels.
 * It limits the categories to 100/priority but... I think that's fine :)
 */
typedef enum {
	NODE_PLAIN=0,
	/* Amenities */
	NODE_POI_START=1,

	NODE_AMENITY_PARKING=100,
	NODE_AMENITY_FUEL=101,
	NODE_AMENITY_SPEEDCAM=102,

	NODE_AMENITY_HOSPITAL=120,
	NODE_AMENITY_PHARMACY=121,
	NODE_AMENITY_POLICE=130,

	NODE_TOURISM_HOTEL=200,
	NODE_TOURISM_HOSTEL=201,
	NODE_TOURISM_MOTEL=202,

	NODE_AMENITY_ATM=205,
	NODE_AMENITY_BANK=206,
	NODE_AMENITY_BUREAU_DE_CHANGE=207,

	NODE_AMENITY_POST=210,
	NODE_AMENITY_POST_BOX=211,

	NODE_TOURISM_INFO=219,

	NODE_AMENITY_TAXI=220,
	NODE_AMENITY_EMBASSY=221,
	NODE_RAILWAY_STATION=230,
	NODE_RAILWAY_HALT=231,
	NODE_AMENITY_BUS_STATION=236,
	NODE_HIGHWAY_BUS_STOP=237,
	NODE_AMENITY_BOAT=240,
	NODE_AIRPORT_TERMINAL=250,

	NODE_TOURISM_CAMP_SITE=280,
	NODE_TOURISM_CARAVAN_SITE=281,
	NODE_TOURISM_PICNIC_SITE=282,

	NODE_AMENITY_RESTAURANT=300,
	NODE_AMENITY_FOOD=301,
	NODE_AMENITY_PUB=302,

	NODE_AMENITY_CINEMA=303,
	NODE_AMENITY_THEATRE=304,
	NODE_AMENITY_SHOP=305,
	NODE_AMENITY_CAFE=306,
	NODE_AMENITY_TELEPHONE=307,
	NODE_AMENITY_WC=308,
	NODE_TOURISM_THEME_PARK=309,
	NODE_AMENITY_POW=310,
	NODE_AMENITY_LIBRARY=311,
	NODE_AMENITY_NIGHTCLUB=312,
	NODE_AMENITY_SHOP_ADULT=313,
	NODE_AMENITY_BROTHEL=314,
	NODE_AMENITY_RECYCLING=315,
	NODE_AMENITY_COLLEGE=320,
	NODE_AMENITY_SCHOOL=321,
	NODE_AMENITY_TOWNHALL=325,
	NODE_TOURISM_ATTRACTION=330,
	NODE_AMENITY_SHOP_COMPUTER=332,

	NODE_HISTORIC_MUSEUM=340,
	NODE_HISTORIC_CASTLE=341,

	/* Sport */
	NODE_SPORT_CENTER=400,
	NODE_SPORT_STADIUM=401,
	NODE_SPORT_SKIING=402,
	NODE_SPORT_SWIMMING=403,
	NODE_SPORT_FOOTBALL=404,
	NODE_SPORT_SOCCER=405,
	NODE_SPORT_GOLF=406,
	NODE_SPORT_TENNIS=407,
	NODE_SPORT_BOWLING=408,
	NODE_SPORT_RUGBY=409,	
	NODE_SPORT_CLIMBING=410,
	NODE_SPORT_MOTOR=411,
	NODE_SPORT_HOCKEY=412,
	NODE_SPORT_BASKETBALL=414,
	NODE_SPORT_CANOE=415,
	NODE_SPORT_BASEBALL=416,
	NODE_SPORT_SKATING=417,
	NODE_SPORT_SKATEBOARD=418,
	NODE_SPORT_RACQUET=419,
	NODE_SPORT_CROQUET=420,
	NODE_SPORT_CRICKET=421,
	NODE_SPORT_PELOTA=422,
	NODE_SPORT_TABLE_TENNIS=423,
	NODE_SPORT_GYMNASTICS=424,
	NODE_SPORT_CYCLING=425,
	NODE_SPORT_BOWLS=426,
	NODE_SPORT_ATHLETICS=427,
	NODE_SPORT_SHOOTING=430,
	NODE_SPORT_PAINTBALL=431,
	NODE_SPORT_DOG=435,
	NODE_SPORT_HORSES=436,
	NODE_SPORT_OTHER=450,

	NODE_AMENITY_GENERIC=900,
	NODE_BUILDING=990,
	/* */
	NODE_POI_END=999,
	/* Places */
	NODE_PLACE_START=1000,
	NODE_PLACE_SUBURB=1001,
	NODE_PLACE_LOCALITY=1002,
	NODE_PLACE_HAMLET=1049,
	NODE_PLACE_VILLAGE=1050,
	NODE_PLACE_ISLAND=1051,
	NODE_PLACE_TOWN=1099,
	NODE_PLACE_CITY=1100,
	NODE_PLACE_AREA=1200,
	NODE_PLACE_COUNTRY=1490,
	NODE_PLACE_END=1500,

	/* Other */
	NODE_TRAFFIC_SIGNALS=2000,
	NODE_GATE=2001,
	NODE_TOLLBOOTH=2002,
	NODE_JUNCTION=2003,

	NODE_TYPE_MAX=9000
} node_type_t;

typedef enum {
	WAY_UNWAYED=0,
	WAY_ROAD_START,
	WAY_MOTORWAY,
	WAY_TRUNK,
	WAY_PRIMARY,
	WAY_SECONDARY,
	WAY_TERTIARY,
	WAY_UNCLASSIFIED,
	WAY_RESIDENTIAL,
	WAY_SERVICE,
	WAY_TRACK,
	WAY_FOOTWAY,
	WAY_CYCLEWAY,
	WAY_ROAD_END,

	/* Non-roads */
	WAY_OTHER_START,
	WAY_RAIL,
	WAY_RUNWAY,
	WAY_TAXIWAY,
	WAY_WATER,
	WAY_WATER_RIVER,
	WAY_WATER_STREAM,
	WAY_WATER_CANAL,
	WAY_OTHER_WAY,
	WAY_OTHER_END
} way_type_t;

/* Route waypoint types */
typedef enum {
	WPT_START,
	WPT_STOP,
	WPT_END
} waypoint_type_t;

/* A place (city,town,village,suburb) */
typedef struct _osm_place osm_place;
struct _osm_place {
	guint32 id;
	node_type_t type;
	gchar *name;
	gint32 lat;
	gint32 lon;
	gdouble dist;
	guint32 isin_p;
	guint32 isin_c;
};

/* Way node */
typedef struct _osm_way_node osm_way_node;
struct _osm_way_node {
	guint32 id;
	guint32 flags;
	gint32 lat;
	gint32 lon;
};

/* Way */
typedef struct _osm_way osm_way;
struct _osm_way {
	guint32	id;
	guint32 isin_c;
	guint32 isin_p;
	gint16 type;
	guint32 flags;
	guint16 nodecnt;
	guint32 f;
	guint32 t;
	gint8 speed;
	gdouble dist;
	gdouble distance;
	gchar *name;
	gchar *ref;
	gchar *int_ref;
	osm_way_node *node_f;
	osm_way_node *node_t;
	gint8 direction;
	GList *nodes;
};

/* Route waypoint */
typedef struct _osm_waypoint osm_waypoint;
struct _osm_waypoint {
	osm_way *way;
	waypoint_type_t type;
};

/* Location: way/street we are on, city/town/village/hamlet and suburb */
/* With helpers, speed and heading at last known location */
typedef struct _osm_location osm_location;
struct _osm_location {
	osm_way *street;
	osm_place *primary;
	osm_place *secondary;
	gboolean changed;
	gboolean valid;
	gint32 lat;
	gint32 lon;
	gfloat heading;
	time_t last_valid;
	gint nfcnt;
};

#endif
