#include "config.h"

#include <dbus/dbus.h>
#include <dbus/dbus-glib.h>
#include <gtk/gtk.h>

#ifdef WITH_HAL
#include <libhal.h>
#endif

#include "ui-common.h"
#include "hildon-mapper.h"

#ifndef _MAPPER_H
#define _MAPPER_H

typedef struct _MapperApp MapperApp;
struct _MapperApp {
	DBusGConnection *dbus_conn;
#ifdef WITH_HAL
	LibHalContext *halctx;
#endif
#ifdef WITH_HILDON
	HildonProgram *program;
#endif
#ifdef WITH_OSSO
	osso_context_t *osso;
#endif
	MapperUi *ui;
};

MapperApp mapper_app;

#endif
