/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 * POI and GPS-Info code originally written by Cezary Jackiewicz.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/****************************************************************************
 * Hildon function wrappers and helpers for hildon/non-hildon builds
 ****************************************************************************/
#include "config.h"

#include <gtk/gtk.h>
#include "ui-common.h"

#ifdef WITH_HILDON
void force_min_visible_bars(HildonControlbar *control_bar, gint num_bars)
{
GValue val;
memset(&val, 0, sizeof(val));
g_value_init(&val, G_TYPE_INT);
g_value_set_int(&val, num_bars);
g_object_set_property(G_OBJECT(control_bar), "minimum-visible-bars", &val);
}
#else
void force_min_visible_bars(GtkWidget *a, gint b)
{
}
#endif

#ifndef WITH_HILDONFM

GtkWidget *
hildon_file_chooser_dialog_new(GtkWindow * parent, GtkFileChooserAction action)
{
GtkWidget *dialog;

if (action == GTK_FILE_CHOOSER_ACTION_SAVE) {
	dialog = gtk_file_chooser_dialog_new("Save", parent, action,
					     GTK_STOCK_CANCEL,
					     GTK_RESPONSE_CANCEL,
					     GTK_STOCK_SAVE,
					     GTK_RESPONSE_OK, NULL);
	gtk_file_chooser_set_do_overwrite_confirmation(GTK_FILE_CHOOSER(dialog), TRUE);
} else {
	dialog = gtk_file_chooser_dialog_new("Open", parent, action,
					     GTK_STOCK_CANCEL,
					     GTK_RESPONSE_CANCEL,
					     GTK_STOCK_OPEN,
					     GTK_RESPONSE_OK, NULL);
}
return dialog;
}

#endif

#ifndef WITH_HILDON

static gint _sb_sid=0;

static gboolean
status_bar_clear(void)
{
gtk_statusbar_pop(mapp.status_bar, 0);
_sb_sid=0;
return FALSE;
}

GtkWidget *
hildon_note_new_confirmation(GtkWindow *window, const gchar *text)
{
return gtk_message_dialog_new(window,
			GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_MESSAGE_ERROR,
			GTK_BUTTONS_OK_CANCEL, text);
}

void 
hildon_banner_show_information(GtkWidget *w, void *t, gchar *text)
{
gtk_statusbar_pop(GTK_STATUSBAR(mapp.status_bar), 0);
gtk_statusbar_push(GTK_STATUSBAR(mapp.status_bar), 0, text);
if (_sb_sid!=0)
	g_source_remove(_sb_sid);
_sb_sid=g_timeout_add(6000, status_bar_clear, NULL);
}

GtkWidget *
hildon_banner_show_progress(GtkWidget *widget, GtkProgressBar *bar, const gchar *text)
{
gtk_widget_show(mapp.progress);
gtk_progress_bar_set_text(mapp.progress, text);
hildon_banner_show_information(mapp.status_bar, NULL, text);
return NULL;
}

void 
hildon_banner_set_fraction(GtkWidget *widget, gdouble fraction)
{
gtk_progress_bar_set_fraction(mapp.progress, fraction);
if (fraction<1.0)
	return;
gtk_progress_bar_set_text(mapp.progress, "");
gtk_progress_bar_set_fraction(mapp.progress, 0.0);
}

GtkWidget *
hildon_banner_show_animation(GtkWidget *widget, const gchar *animation_name, const gchar *text)
{
hildon_banner_show_information(mapp.status_bar, NULL, text);
gtk_progress_bar_set_text(mapp.progress, text);
gtk_progress_bar_pulse(mapp.progress);
return NULL;
}

GtkWidget *
hildon_number_editor_new(gint min, gint max)
{
return gtk_spin_button_new_with_range(min, max, 1);
}

gint 
hildon_number_editor_get_value(GtkWidget * w)
{
return gtk_spin_button_get_value_as_int(GTK_WIDGET(w));
}

void 
hildon_number_editor_set_value(GtkWidget * w, gint v)
{
gtk_spin_button_set_value(w, v);
}

void 
hildon_number_editor_set_range(GtkWidget * w, gint min, gint max)
{
gtk_spin_button_set_range(w, min, max);
}

GtkWidget *
hildon_controlbar_new()
{
return gtk_hscale_new_with_range(1, 10, 1);
}

gint 
hildon_controlbar_get_value(GtkWidget * w)
{
return gtk_range_get_value(w);
}

void
hildon_controlbar_set_value(GtkWidget * w, gint v)
{
gtk_range_set_value(w, (gdouble)v);
}

void
hildon_controlbar_set_range(GtkWidget * w, gint min, gint max)
{
gtk_range_set_range(w, (gdouble)min, (gdouble)max);
}

#else

void
hildon_banner_hide(GtkWidget *w)
{
gtk_widget_destroy(w);
}

#endif
