/*
 *
 * GtkGps: Display GPS satellite information
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __GTK_GPS_H__
#define __GTK_GPS_H__

#include <gtk/gtk.h>
#include "gpsdata.h"

G_BEGIN_DECLS

#define GTK_GPS_TYPE			(gtk_gps_get_type ())
#define GTK_GPS(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_GPS_TYPE, GtkGps))
#define GTK_GPS_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_GPS_TYPE, GtkGpsClass))
#define GTK_IS_GPS(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_GPS_TYPE))

typedef struct _GtkGps			GtkGps;
typedef struct _GtkGpsClass		GtkGpsClass;

typedef enum {
	GTK_GPS_MODE_SKY,
	GTK_GPS_MODE_SIGNAL,
	GTK_GPS_MODE_COMBINED,
} GtkGpsMode;

struct _GtkGps {
	GtkDrawingArea widget;
	GdkGC *gc1;
	GdkGC *gc_s;
	GdkGC *gc_sf;
	GdkGC *gc_w;
	gint width, height;
	gint size;
	gfloat fs;
	GtkGpsMode display_mode;

	PangoContext *context;
	PangoLayout *layout;
	PangoFontDescription *fontdesc;

	GpsData *data;
	gint esid;
};

struct _GtkGpsClass {
	GtkWidgetClass parent_class;
};

GType gtk_gps_get_type(void);
GtkWidget* gtk_gps_new(GtkGpsMode display_mode, GpsData *data);
void gtk_gps_refresh(GtkWidget *widget);

G_END_DECLS

#endif /* __GTK_GPS_H__ */
