#ifndef _GPS_DATA_H
#define _GPS_DATA_H

#include <glib.h>

#define GPS_SAT_MAX	(20)

typedef enum {
        FIX_NOFIX=1,
        FIX_2D=2,
        FIX_3D=3
} GpsFix;

/**
 * Gps satellite data
 */
typedef struct _GpsSatelliteData GpsSatelliteData;
struct _GpsSatelliteData {
	gint prn;
	gint elevation;
	gint azimuth;
	gint snr;
	gboolean fix;
};

/** 
 * GPS Data and Satellite signal information
 */
typedef struct _GpsData GpsData;
struct _GpsData {
	gdouble lat;
	gdouble lon;
	guint unitx;
	guint unity;
	time_t time;
	GpsFix fix;
	gboolean newly_fixed;
	guint fixquality;
	gfloat speed;
	gfloat maxspeed;
	gfloat avgspeed;
	gfloat altitude;
	gfloat heading;
	gfloat lheading;
	gfloat hdop;
	gfloat vdop;
	gfloat pdop;
	gint vel_offsetx;
	gint vel_offsety;
	guint satinview;
	guint satinuse;
	GpsSatelliteData sat[GPS_SAT_MAX];
};

#endif
