#ifndef _CONFIG_GCONF_H
#define _CONFIG_GCONF_H

#include <gconf/gconf-client.h>
#include <gtk/gtk.h>
#include "filter.h"
#include "mapper-types.h"
#include "map-repo.h"
#include "path.h"

GConfClient *gconf_client;

void config_init(void);
gboolean config_save(void);

gboolean config_save_repo(void);
gboolean config_load_repo(void);
RepoData *config_parse_repo(gchar *str);

gboolean config_load_position(Position *pos, const gchar *key);
gboolean config_save_position(Position *pos, const gchar *key);

gboolean config_save_filter(GpsTrackFilter *f);

gboolean config_load_string_list(const gchar *gconf_key, GSList **list, GtkListStore **model);

void config_update_proxy(void);

#endif
