/*
 * poi-osm-fetcher.h - Headers for OpenStreetMap Point of Interest fetcher
 * Copyright (C) 2010 Collabora Ltd
 * @author Cosimo Alfarano <cosimo.alfarano@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTRCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MAP_BUDDY_POI_OSM_FETCHER_H
#define MAP_BUDDY_POI_OSM_FETCHER_H

#include <glib-object.h>

G_BEGIN_DECLS

#define MAP_BUDDY_POI_OSM_FETCHER_TYPE     (map_buddy_poi_osm_fetcher_get_type())
#define MAP_BUDDY_POI_OSM_FETCHER(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), \
      MAP_BUDDY_POI_OSM_FETCHER_TYPE, MapBuddyPoiOsmFetcher))
#define MAP_BUDDY_POI_OSM_FETCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),  MAP_BUDDY_POI_OSM_FETCHER_TYPE, \
                           MapBuddyPoiOsmFetcherClass))
#define MAP_BUDDY_IS_POI_OSM_FETCHER(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
      MAP_BUDDY_POI_OSM_FETCHER_TYPE))
#define MAP_BUDDY_IS_POI_OSM_FETCHER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),  MAP_BUDDY_POI_OSM_FETCHER_TYPE))
#define MAP_BUDDY_POI_OSM_FETCHER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj),  MAP_BUDDY_POI_OSM_FETCHER_TYPE, \
                             MapBuddyPoiOsmFetcherClass))

typedef struct _MapBuddyPoiOsmFetcher MapBuddyPoiOsmFetcher;
typedef struct _MapBuddyPoiOsmFetcherClass MapBuddyPoiOsmFetcherClass;

#define DATA_FETCH_ERROR_DOMAIN g_quark_from_static_string ("data-fetch-error")
typedef enum
{
  CANCELLED
} MapBuddyPoiOsmFetcherError;

GType map_buddy_poi_osm_fetcher_get_type (void);

typedef void (*MapBuddyPoiOsmFetcherGetCallBack) (MapBuddyPoiOsmFetcher *self,
    const GError **error, gpointer user_data);

MapBuddyPoiOsmFetcher *map_buddy_poi_osm_fetcher_new (void);
void map_buddy_poi_osm_fetcher_get (MapBuddyPoiOsmFetcher *self, gdouble left,
    gdouble buttom, gdouble right, gdouble top,
    MapBuddyPoiOsmFetcherGetCallBack cb, gpointer user_data);

void map_buddy_poi_osm_fetcher_start (MapBuddyPoiOsmFetcher *self);

G_END_DECLS

#endif
