#ifndef VIEW_H
#define VIEW_H

#include <fence.h>
#include <QGraphicsView>
#include <QGraphicsScene>
#include <iostream>
#include "poi.h"
#include <vector>
#include <QMouseEvent>
#include <clock.h>
#include <QTimer>
#include <icon.h>
#include <platform.h>
#include <game.h>
#include <QInputDialog>
#include <QLineEdit>
#include <twitcurl.h>
#include <QInputContext>

class Game;
class Clock;
class Fence;
class Icon;
class Poi;
class Platform;


enum Depth
{
iconDepth,
platformDepth,
fenceDepth,	
poiDepth,	
sheepDepth,
clockDepth

};

class View:public QGraphicsView
{
	Q_OBJECT
	public:
		View(QGraphicsScene* scene_);
		void mousePressEvent(QMouseEvent * event);
		void mouseMoveEvent(QMouseEvent* event);
		void mouseReleaseEvent(QMouseEvent* event);
		
		static Game* game;
		
		std::vector<Poi*> pois;
		QGraphicsScene* scene;	
		std::vector<Fence*> fences;
		Clock* clock;
		std::vector<Icon*> icons;

		Poi* poi;
		Icon* activeIcon;
	
		std::vector<Platform*> platforms;
	
		void win();
	
		QLineEdit* username;
		QLineEdit* password;
		QPushButton* ok;
		QPushButton* cancel;
		QGridLayout* infoLayout;
		
		
	public slots:
		void removeItem(Poi*);
		void twitOk();
		void twitCancel();
		void rewindBackgroundSound();
};	




#endif
