#ifndef FENCE_H
#define FENCE_H
#include <baseobj.h>
#include <algorithm>
#include <QGraphicsItem>
#include <game.h>
#include <view.h>
#include <sheep.h>
#include <vector>
#include <soundengine.h>

class Sheep;
class View;
class SoundEngine;
class Game;

class Fence: public QGraphicsItem, public BaseObj
{
public:
		
	Fence();
	QRectF boundingRect() const;
	QPainterPath shape() const;
	void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);
	static Game* game;
	static View* view;
	qreal x;
	qreal y;
	qreal cRotation;
	qreal dRotation;
	int active;
	std::vector<Sheep*> sheepIn;
	void addSheep(Sheep* sheep_);
	int closeCounter;
	int dogIn;

	void platformActivate();
	void platformDeactivate();

protected:

	void advance(int step);
		



};


#endif
