#include <clock.h>


Game* Clock::game=NULL;

Clock::Clock()
{
	setZValue(clockDepth);
	x=670;
	y=450;
	value=0;	

	bahValue=11;
}

void Clock::paint(QPainter* painter, const QStyleOptionGraphicsItem *option, QWidget* widget)
{


	if (!game->won)
	{
		painter->save();
		painter->setBrush(Qt::red);
		painter->setPen(Qt::red);
		QFont serifFont("Times", 40, QFont::Bold);
		painter->setFont(serifFont);
		painter->setOpacity(0.4);
		painter->drawText(0,0,QString::number(value));
		painter->restore();
	}
	else
	{

		game->score=value;

	       	painter->save();
	     	painter->setBrush(Qt::red);
		painter->setPen(Qt::red);
		QFont serifFont("Times", 80, QFont::Bold);
		painter->setFont(serifFont);
		painter->setOpacity(0.8);
		painter->drawText(0,0,"You win!");
		painter->drawText(130,100,QString::number(value));
		
		
		painter->restore();

																 

	}
		

}

QRectF Clock::boundingRect() const
{
	return QRectF(0,0,1,1);
}


void Clock::advance(int step)
{
	if (!step)
		return;

	
	if (!game->won)
		setPos(x,y);
	else
		setPos(220,80);

}


void Clock::tick()
{
	if (game->pauseOn)
		return;

	
	++value;


	if ((value%bahValue)==0 && game->sound)
	{
	
		bahValue=3*(qrand()%3+1);
		pthread_t bahSoundThread;
	        pthread_create(&bahSoundThread,NULL,&SoundEngine::playSingleBah,NULL);
		

	}
}


