#ifndef DATABASE_H
#define DATABASE_H

#include <QSqlDatabase>
#include <QSqlQuery>
#include <QDir>
#include <QFile>

//select calendars that have recursive events
const QString SQL_GET_CAL_WITH_RECURRING =  "select distinct a.calendarid, a.name, a.colour, ' ' delegate, calendartype from calendars a join components b on a.calendarid=b.calendarid join recursive c on b.id=c.id where a.isreadonly = 0";

//select recursive events for a specific calendar
#define SQL_GET_

const QString DB_CAL = QDir::homePath() + "/.calendar/calendardb";

bool db_connect();
bool db_create();
void db_sync();
int db_getInbox();


#endif // DATABASE_H
