#include "database.h"

#include <QFile>
#include <QSqlDatabase>
#include <QSqlQuery>
#include <QSqlError>
#include <QVariant>
#include <iostream>

using namespace std;

bool db_connect()
{
    bool ok = QFile::exists(DB_CAL);
    if(!ok){
        return false;
    }

    QSqlDatabase db = QSqlDatabase::addDatabase("QSQLITE");
    db.setDatabaseName(DB_CAL);
    if (!db.open()) {
        return false;
    }

    return ok;
}

int db_getCalendarsWithRecurring()
{
    QSqlQuery query;
    query.exec(SQL_GET_CAL_WITH_RECURRING);

    if(query.next()){
        return query.value(0).toInt();
    } else
    {
        return -1;
    }
}

bool db_create()
{
    int err_count = 0;
    bool ok = false;
    QSqlQuery query;

    ok = query.exec( "CREATE TABLE Parent("
                            "PlusId INTEGER PRIMARY KEY AUTOINCREMENT, "
                            "Id INTEGER, "
                            "CalendarId INTEGER,"
                            "ComponentType INTEGER,"
                            "Parent INTEGER,"
                            "System INTEGER,"
                            "Sequence INTEGER,"
                            "Summary TEXT)");

    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    ok = query.exec("CREATE INDEX IDX_Parent_Id on Parent(Id)");
    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    ok = query.exec("CREATE INDEX IDX_Parent_Parent on Parent(Parent)");
    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }
    //create Inbox system group and other recommended groups
    ok = query.exec("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                    " VALUES(0,0,500,0,1,-900,'Inbox')");
    ok = query.exec("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                    " VALUES(0,0,500,0,0,-700,'Projects')");
    ok = query.exec("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                    " VALUES(0,0,500,0,0,-400,'Someday')");
    if(!ok){
        err_count++;
        cout << query.lastError().text().toLocal8Bit().constData();
    }

    if(err_count > 0){
        return false;
    } else {
        return true;
    }

}

int db_getInbox()
{
    QSqlQuery query;
    query.exec("select plusid from parent where summary='Inbox'");
    if(query.next()){
        return query.value(0).toInt();
    } else
    {
        return -1;
    }
}

void db_sync()
{
    int inbox_id = db_getInbox();
    int err_count = 0;
    int ok_count = 0;
    QSqlQuery query;

    bool ok = query.exec("select id, calendarid, componenttype, summary "
               "from calendar.components a where a.componenttype = 2 and a.id not in (select id from parent)");
    if(!ok){
        cout << "select query failed!" << endl;
    }

    QSqlQuery query2;
    query2.prepare("Insert into parent (Id,CalendarId,ComponentType,Parent,System,Sequence,Summary)"
                   " VALUES(:id,:calendarid,:componenttype,:parent,:system,:sequence,:summary)");
    cout << "Looping" << endl;
    while(query.next())
    {
        cout << ":id\t" << query.value(0).toInt() << endl;
        cout << ":calendarid\t" << query.value(1).toInt() << endl;
        cout << ":componenttype\t" << query.value(2).toInt() << endl;
        cout << ":summary\t" << query.value(3).toString().toLocal8Bit().constData() << endl;
        query2.bindValue(":id", query.value(0).toInt());
        query2.bindValue(":calendarid", query.value(1).toInt());
        query2.bindValue(":componenttype", query.value(2).toInt());
        query2.bindValue(":summary", query.value(3).toString());
        query2.bindValue(":parent", inbox_id);
        query2.bindValue(":system", 0);
        query2.bindValue(":sequence", 0);
        ok = query2.exec();
        if(ok)
        {
            ok_count++;
        } else
        {
            cout << query2.lastError().text().toLocal8Bit().constData() << endl;
            err_count++;
        }

    }
    cout << "Success:" << ok_count << endl;
    cout << "Failed:" << err_count << endl;
}
