# -*- coding: utf-8 -*-
import logging
from weibopy.error import WeibopError

__author__="Michael"
__date__ ="$2011-9-1$"

from qqweibo.auth import OAuthHandler
from qqweibo.api import API
from qqweibo.parsers import JSONParser
from Logger import Logger
from Writer import Writer
from Downloader import Downloader
from PyQt4.QtCore import *
import Utils
import os
import time

APP_KEY = 'de5f447222ac49189edc36cd061806c6'
APP_SECRET = '7ba914334cfc0ef56271de89be36cdb0'

class UpdaterQQ(QThread):
    def __init__(self,callback,parent=None):
        super(UpdaterQQ, self).__init__(parent)
        self.logger = logging.getLogger('UpdaterQQ')
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
#        self.logger =logger
        self.writer = Writer()
        self.downloader = Downloader()
        self.callback=callback
        self.logger.debug("UpdaterQQ:__init__")

    def basicAuth(self, source, username, password):
        self.auth = BasicAuthHandler(username, password)
        self.api = API(self.auth,source=source)

    def OAuth(self, username, password):
        #self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        #auth_url = self.auth.get_authorization_url()
        #print 'Please authorize: ' + auth_url
        #verifier = raw_input('PIN: ').strip()
        #self.auth.get_access_token(verifier)
        #self.api = API(self.auth)
        
        self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        self.auth.setToken(username, password)
        self.api = API(self.auth, parser=JSONParser())

    def initialize(self, accountId,timelineType,pageflat,pagetime,countnum,downpic, rootid=None):
        self.logger.debug("UpdaterQQ:initialize")
        self.stopped = False
        self.accountId=accountId
        self.timelineType=timelineType
        self.pageflat=pageflat
        self.pagetime=pagetime
        self.countnum=countnum
        self.downpic=downpic
        self.completed = False
        self.timeline = []
        self.rootid = rootid


    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        try:
            self.update_timeline(self.pageflat,self.pagetime,self.countnum,self.rootid)
        except WeibopError,we:
            self.completed=False
            self.emit(SIGNAL("finished(bool)"),self.completed)
            self.emit(SIGNAL("show_notice(QString,int)"),we.reason,0)
        self.stop()


    def update_timeline(self,pageFlag=0,pagetime=0,countNum=10, rootid=None):
        self.logger.debug("update_timeline")
        param={}
        param1={}
        param["type"]=0
        param["contenttype"]=7
        param["reqnum"]=countNum
        param["pageflag"]=pageFlag
        param["pagetime"]=pagetime
        timeline=None
        
        if self.timelineType==Utils.TIMELINE_TYPE_FRIENDS:
            timeline = self.api.timeline.home(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_DM:
            timeline = self.api.timeline.broadcast(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            timeline = self.api.timeline.mentions(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            param["type"]=80
            timeline = self.api.timeline.broadcast(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_ST_COMMENTS:
            param1["twitterid"]=0
            param1["reqnum"]=countNum
            param1["pageflag"]=pageFlag
            param1["pagetime"]=pagetime            
            param1["rootid"]= rootid           
            param1["flag"]=1
            timeline = self.api.tweet.retweetlist(**param1)
        elif self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
            param={}
            param["source"]=APP_KEY
            param["id"]=1863105202
            timeline = self.api.favorites(**param)
	
        if timeline['data']!=None:
            for line in timeline['data']['info']:
                #print "!!!!!!!!!!!!!!!!!!"
                
                #print line["id"]
                #print line["text"]
                #print line["origtext"]
                #print "------------------"
                status=Utils.build_a_status_from_obj_qq(line,self.accountId)
                
                self.timeline.append(status)
                
                # download images.
                
                if self.downpic=="True":
                    thumbnail=status["thumbnail_pic"]
                    if thumbnail!=None:
                        filename=thumbnail.split("/")[-2]
                        picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(status["id"])+"_"+filename
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(thumbnail)
                            self.writer.write_to(picFilename, picSource)
                    user=status["user"]
                    
                    avatar=user["profile_image_url"]
                    if avatar!=None:
                        picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(user["id"])
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(avatar)
                            self.writer.write_to(picFilename, picSource)

                    
                    if status["if_rt"]==True:
                        rtStatus=status["retweeted_status"]
                        rtUser=rtStatus["user"]
                        rtAvatar=rtUser["profile_image_url"]
                        if rtAvatar!=None:
                            picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(rtUser["id"])
                            if os.access(picFilename, os.W_OK) == 0:
                                picSource=self.downloader.download(rtAvatar)
                                self.writer.write_to(picFilename, picSource)
                                
                        rtThumbnail=rtStatus["thumbnail_pic"]
                        if rtThumbnail!=None:
                            filename=rtThumbnail.split("/")[-2]
                            picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(rtStatus["id"])+"_"+filename
                            if os.access(picFilename, os.W_OK) == 0:
                                picSource=self.downloader.download(rtThumbnail)
                                self.writer.write_to(picFilename, picSource)
                
        self.completed = True
        if self.timelineType!=Utils.TIMELINE_TYPE_ST_COMMENTS:   
            self.emit(SIGNAL("finished(bool)"),self.completed)
        else:
            self.emit(SIGNAL("cm_finished(bool)"),self.completed)
        self.logger.info("update completed!")

        

class SenderQQ(QThread):
    def __init__(self,callback,parent=None):
        super(SenderQQ, self).__init__(parent)
        self.logger = logging.getLogger('SenderQQ')
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
        self.callback=callback
#        self.logger =logger
#        self.writer = Writer()
#        self.downloader = Downloader()
        self.logger.debug("SenderQQ:__init__")


    def basicAuth(self, source, username, password):
        self.auth = BasicAuthHandler(username, password)
        self.api = API(self.auth,source=source)

    def OAuth(self, token, tokenSecret):
        self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        self.auth.setToken(token, tokenSecret)
        self.api = API(self.auth)

    def initialize(self, accountId,param):
        self.logger.debug("SenderQQ:initialize")
        self.stopped = False
        self.accountId=accountId
        self.param=param
        self.completed = False

    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        try:
            self.send(self.param)
        except WeibopError,we:
            self.completed=False
            self.emit(SIGNAL("finished(bool)"),self.completed)
            self.emit(SIGNAL("show_notice(QString,int)"),we.reason,0)
        self.stop()


    def send(self, param):
        self.logger.debug("sending")
        param["source"]=APP_KEY
        param["clientip"]="127.0.0.1"
        #param["jing"]=param["lat"]
        #param["wei"]=param["long"]
        
        if param["timelineType"]==4:
            param["content"]=param["comment"]
            param["reid"]=param["id"]
        elif param["timelineType"]==2:
            param["content"]=param["text"]
            param["name"]=param["id"]
        else:
            param["content"]=param["status"]
        
        timelineType=param["timelineType"]
        if timelineType==None:
            self.logger.debug("send a normal msg")
#            if hasattr(param, 'pic'):
            try:
                pic=str(param["pic"])
                self.logger.debug("with a picture:"+pic)
                status=self.api.tweet.addpic(pic,str(param["status"]))
            except KeyError,ae:
#            else:
                self.logger.error(os.sys.exc_info()[0])
                self.logger.debug(ae)
                self.logger.debug("just a text msg")
                status=self.api.tweet.add(**param)
        elif timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            self.logger.debug("send a rt")
            #rt
            param["reid"]=param["id"]
            status=self.api.tweet.retweet(**param)
        elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            #rt it first
            try:
                if param["without_mention"]==2:
                    param["reid"]=param["id"]
                    print "#rt it first"
                    status=self.api.tweet.retweet(**param)
                print "and comment it"   
                time.sleep(5)
                status=self.api.tweet.comment(**param)
            except KeyError,ae:
                pass
                
            try:
                param["reid"]=param["cid"]
                status=self.api.tweet.reply(**param)
            except KeyError,ae:
                #comment
                self.logger.debug("send a comment")
                print "comment it only"    
                status=self.api.tweet.comment(**param)
        elif timelineType==Utils.TIMELINE_TYPE_DM:
            #dm
            self.logger.debug("send a dm")
            status=self.api.private.add(**param)
        self.completed = True
        self.emit(SIGNAL("finished(bool)"),self.completed)
        self.logger.info("sending completed!")

