/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WEBVIEW_H
#define WEBVIEW_H

#include <QtWebKit>
#include <QtGui>
#include <QTime>

#include "webpage.h"

class FlickableTicker;

class WebView : public QWebView
{
    Q_OBJECT

public:
    typedef enum {
        Steady,
        Pressed,
        ManualScroll,
        AutoScroll,
        Stop,
        Bug
    } State;

public:
    friend class FlickableTicker;
    WebView(QWidget *parent = 0);

    void setScrollOffset(const QPoint &offset);
    QPoint scrollOffset() const;

protected:
    void keyReleaseEvent(QKeyEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    QWebView* createWindow ( QWebPage::WebWindowType type );

private:
    void tick();

private:
    State m_state;
    int m_threshold;
    QPoint m_pressPos;
    QPoint m_offset;
    QPoint m_delta;
    QPoint m_speed;
    FlickableTicker *m_pTicker;
    QTime m_timeStamp;
    QList<QEvent*> m_ignoreList;
};

#endif // WEBVIEW_H
