#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QLabel>

#ifdef Q_WS_MAEMO_5
    #include <QGraphicsWebView>
    #include "graphicsview.h"

    #include "pickselectoraction.h"
#endif

#include "webview.h"
#include "errorbox.h"
#include "toolbar.h"
#include "minifiedtoolbar.h"
#include "bookmark.h"
#include "webpage.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT

public:
    explicit MainWindow(MainWindow *pParent);
    virtual ~MainWindow();

    void adjustSizes(); //manually adapt layout to new size
    void keyPressEvent(QKeyEvent *event);

    QWebPage *page();
    MainWindow *createWindow();
    MainWindow *topMost();

    QWebView *getWebView() { return m_pWebView; }

private:
    void loadSettings();
    void saveSettings();

    bool isFullScreen();

    // reimplement resize event to adapt layout
    void resizeEvent(QResizeEvent* event);

    //intercepts close event
    void closeEvent(QCloseEvent *event);

    void zoomIn();
    void zoomOut();
    void zoomFit();
    void setZoom(qreal zoomFactor);
    void setWidget();
    void createMenu();

    void enableWebkitAutoSize();
    void setUserAgent(bool iphone=true);

#ifdef Q_WS_MAEMO_5
    void grabZoomKeys(bool grab);
    bool isLandscape();
    bool isAutoRotate();
    void setLandscape(bool landscape=true);
    void setAutoRotate(bool autoRotate=true);
#else
    //white overlay behind the error message
    void showOverlayOnPage();
    void hideOverlayOnPage();
#endif

private slots:
    void on_actionUser_Agent_triggered();
    void on_actionAdd_Bookmark_triggered();
    void on_actionGo_To_triggered();
    void on_actionAuto_Rotate_triggered();
    void on_actionLandscape_triggered();
    void on_actionBookmarks_triggered();
    void on_actionHome_triggered();

    void aboutQt();
    void switchView();
    void setFullScreen(bool full=true);
    void showLoading(); //called when a "loading page" is started
    void changeUrl(QUrl url); //called when the url is changed. The url will be used on the retry action
    void hideLoading(bool success); //called when a "loading page" is finished
    void reload(); //reload the page

    void finishedRequest(QNetworkReply* reply); //request

    // QWebView/QWebPage
    void linkClicked ( const QUrl & url );
    void unsupportedContent(QNetworkReply*);
    void downloadRequested (const QNetworkRequest& request);

    void userAgent_selectionChanged(int index);
    void orientation_selectionChanged(int index);

#ifdef Q_WS_MAEMO_5
    void orientationChanged();
    void fullscreen_triggered();
#else
    //toolbar visibility control
    void showToolbar();
    void hideToolbar();
#endif

    //visit url
    void visitUrl(QString);

private:
    bool            m_isUsingGraphicsView;

    // mainWindow components
    QUrl            m_currentUrl;
    qreal           m_zoomFactor;
    QLabel          *m_pLoadingLabel;
    QStringList     m_errors;

    QList<Bookmark> *m_pBookmarks;
    WebPage         m_webPage;
    MainWindow      *m_pParent;
    QList<MainWindow *> m_children;

    WebView             *m_pWebView;

    // v2
    QGraphicsWebView *m_pGWebView;
    GraphicsView     *m_pGraphicsView;

#ifdef Q_WS_MAEMO_5
    PickSelectorAction  *m_pUserAgentSelector;
    PickSelectorAction  *m_pOrientationSelector;
#else
    ErrorBox* m_pErrorBox;
    Toolbar* m_pToolbar;
    MinifiedToolbar* m_pMiniToolbar;
#endif

};

#endif // MAINWINDOW_H
