#include "bookmarksdlg.h"
#include "ui_bookmarksdlg.h"

#include "bookmarkdlg.h"

#include <QDebug>

BookmarksDlg::BookmarksDlg(QList<Bookmark>& list, QWidget *pParent) :
    QDialog(pParent),
    m_pUI(new Ui::BookmarksDlg),
    m_bookmarks(list)
{
    m_pUI->setupUi(this);

    loadItems();

#ifdef Q_WS_MAEMO_5
    m_pUI->buttonBox->hide();
#endif
}

void BookmarksDlg::loadItems() {
    m_pUI->listWidget->clear();

    for ( int c=m_bookmarks.count()-1; c>=0; c-- ) {
        QListWidgetItem *pItem = new QListWidgetItem(m_pUI->listWidget);
        pItem->setText(m_bookmarks[c].title());

        QVariant tag;
        tag.setValue(m_bookmarks[c]);
        pItem->setData(Qt::UserRole, tag );

        m_pUI->listWidget->addItem(pItem);
    }
}

BookmarksDlg::~BookmarksDlg()
{
    delete m_pUI;
}

void BookmarksDlg::changeEvent(QEvent *pEvent)
{
    QDialog::changeEvent(pEvent);
    switch (pEvent->type()) {
        case QEvent::LanguageChange:
            m_pUI->retranslateUi(this);
            break;

        default:
            break;
    }
}

void BookmarksDlg::on_listWidget_itemClicked(QListWidgetItem* pItem)
{
    QVariant var;
    var = pItem->data(Qt::UserRole);
    if ( !var.isValid() || var.isNull() ) {
        m_pItem = NULL;
        m_bookmark.setUrl(QString::null); // invalid
        return;
    }

    m_pItem = pItem;
    m_bookmark = var.value<Bookmark>();
}

void BookmarksDlg::on_listWidget_itemDoubleClicked(QListWidgetItem* pItem)
{
    if ( m_bookmark.isNull() ) return;
    accept();
}

void BookmarksDlg::on_listWidget_customContextMenuRequested(QPoint pos)
{
    /*
    QModelIndex t = m_pUI->listWidget->indexAt(pos);
    QListWidgetItem* pItem = m_pUI->listWidget->item(t.row());
    pItem->setSelected(true); // even a right click will select the item

    QVariant var;
    var = pItem->data(Qt::UserRole);
    if ( !var.isValid() ) return;

    m_bookmark = var.value<Bookmark>();
    */

    if ( !m_pItem || m_bookmark.isNull() ) return;

    BookmarkDlg dlg(this);
    dlg.setTitle(m_bookmark.title());
    dlg.setUrl(m_bookmark.url());
    connect((QObject*)dlg.removeBtt(), SIGNAL(clicked()), this, SLOT(onRemoveBookmark()));
    if ( dlg.exec() != QDialog::Accepted ) return;

    int index = m_bookmarks.indexOf(m_bookmark);

    // update
    m_bookmark.setTitle(dlg.title());
    m_bookmark.setUrl(dlg.url());
    m_bookmarks.replace(index, m_bookmark);

    m_pItem->setText(m_bookmark.title());
}

void BookmarksDlg::onRemoveBookmark() {
    m_bookmarks.removeAll(m_bookmark);

    // how to remove item for list?
    // ...

    // for now reload all items
    loadItems();
}
